/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.keyring;

import gnu.java.security.Registry;
import gnu.javax.crypto.cipher.CipherFactory;
import gnu.javax.crypto.cipher.IBlockCipher;
import gnu.javax.crypto.keyring.Entry;
import gnu.javax.crypto.keyring.MalformedKeyringException;
import gnu.javax.crypto.keyring.MaskableEnvelopeEntry;
import gnu.javax.crypto.keyring.Properties;
import gnu.javax.crypto.mode.IMode;
import gnu.javax.crypto.mode.ModeFactory;
import gnu.javax.crypto.pad.IPad;
import gnu.javax.crypto.pad.PadFactory;
import gnu.javax.crypto.pad.WrongPaddingException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.util.HashMap;

public class EncryptedEntry
extends MaskableEnvelopeEntry
implements Registry {
    public static final int TYPE = 0;

    public EncryptedEntry(String string, String string2, Properties properties) {
        super(0, properties);
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("neither cipher nor mode can be null");
        }
        properties.put("cipher", string);
        properties.put("mode", string2);
        this.setMasked(false);
    }

    private EncryptedEntry() {
        super(0, new Properties());
        this.setMasked(true);
    }

    public static EncryptedEntry decode(DataInputStream dataInputStream) throws IOException {
        EncryptedEntry encryptedEntry = new EncryptedEntry();
        encryptedEntry.defaultDecode(dataInputStream);
        if (!encryptedEntry.properties.containsKey("cipher")) {
            throw new MalformedKeyringException("no cipher");
        }
        if (!encryptedEntry.properties.containsKey("cipher")) {
            throw new MalformedKeyringException("no cipher");
        }
        return encryptedEntry;
    }

    public void decrypt(byte[] byArray, byte[] byArray2) throws IllegalArgumentException, WrongPaddingException {
        int n;
        if (!this.isMasked() || this.payload == null) {
            return;
        }
        IMode iMode = this.getMode(byArray, byArray2, 2);
        IPad iPad = null;
        iPad = PadFactory.getInstance("PKCS7");
        iPad.init(iMode.currentBlockSize());
        byte[] byArray3 = new byte[this.payload.length];
        int n2 = 0;
        for (n = 0; n < this.payload.length; ++n) {
            iMode.update(this.payload, n2, byArray3, n2);
            n2 += iMode.currentBlockSize();
        }
        n = iPad.unpad(byArray3, 0, byArray3.length);
        int n3 = byArray3.length - n;
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray3, 0, n3));
        try {
            this.decodeEnvelope(dataInputStream);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("decryption failed");
        }
        this.setMasked(false);
        this.payload = null;
    }

    public void encrypt(byte[] byArray, byte[] byArray2) throws IOException {
        Object object2;
        IMode iMode = this.getMode(byArray, byArray2, 1);
        IPad iPad = PadFactory.getInstance("PKCS7");
        iPad.init(iMode.currentBlockSize());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        for (Object object2 : this.entries) {
            ((Entry)object2).encode(dataOutputStream);
        }
        Object object3 = byteArrayOutputStream.toByteArray();
        object2 = iPad.pad((byte[])object3, 0, ((Object)object3).length);
        this.payload = new byte[((Object)object3).length + ((Object)object2).length];
        byte[] byArray3 = new byte[iMode.currentBlockSize()];
        int n = iMode.currentBlockSize() - ((Object)object2).length;
        System.arraycopy(object3, ((Object)object3).length - n, byArray3, 0, n);
        System.arraycopy(object2, 0, byArray3, n, ((Object)object2).length);
        int n2 = 0;
        while (n2 + iMode.currentBlockSize() < ((Object)object3).length) {
            iMode.update((byte[])object3, n2, this.payload, n2);
            n2 += iMode.currentBlockSize();
        }
        iMode.update(byArray3, 0, this.payload, n2);
    }

    public void encodePayload() throws IOException {
        if (this.payload == null) {
            throw new IOException("not encrypted");
        }
    }

    private IMode getMode(byte[] byArray, byte[] byArray2, int n) {
        IMode iMode;
        IBlockCipher iBlockCipher = CipherFactory.getInstance(this.properties.get("cipher"));
        if (iBlockCipher == null) {
            throw new IllegalArgumentException("no such cipher: " + this.properties.get("cipher"));
        }
        int n2 = iBlockCipher.defaultBlockSize();
        if (this.properties.containsKey("block-size")) {
            try {
                n2 = Integer.parseInt(this.properties.get("block-size"));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("bad block size: " + numberFormatException.getMessage());
            }
        }
        if ((iMode = ModeFactory.getInstance(this.properties.get("mode"), iBlockCipher, n2)) == null) {
            throw new IllegalArgumentException("no such mode: " + this.properties.get("mode"));
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("gnu.crypto.cipher.key.material", byArray);
        hashMap.put("gnu.crypto.mode.state", n);
        hashMap.put("gnu.crypto.mode.iv", byArray2);
        try {
            iMode.init(hashMap);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException(invalidKeyException.toString());
        }
        return iMode;
    }
}

