/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.key.srp6;

import gnu.java.security.hash.IMessageDigest;
import gnu.java.security.util.Util;
import gnu.javax.crypto.key.IncomingMessage;
import gnu.javax.crypto.key.KeyAgreementException;
import gnu.javax.crypto.key.OutgoingMessage;
import gnu.javax.crypto.key.srp6.SRP6KeyAgreement;
import gnu.javax.crypto.key.srp6.SRPKeyPairGenerator;
import gnu.javax.crypto.key.srp6.SRPPrivateKey;
import gnu.javax.crypto.key.srp6.SRPPublicKey;
import gnu.javax.crypto.sasl.srp.SRP;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;

public class SRP6User
extends SRP6KeyAgreement {
    private String I;
    private byte[] p;
    private KeyPair userKeyPair;

    protected void engineInit(Map map) throws KeyAgreementException {
        this.rnd = (SecureRandom)map.get("gnu.crypto.srp6.ka.prng");
        this.N = (BigInteger)map.get("gnu.crypto.srp6.ka.N");
        if (this.N == null) {
            throw new KeyAgreementException("missing shared modulus");
        }
        this.g = (BigInteger)map.get("gnu.crypto.srp6.ka.g");
        if (this.g == null) {
            throw new KeyAgreementException("missing generator");
        }
        String string = (String)map.get("gnu.crypto.srp6.ka.H");
        if (string == null || string.trim().length() == 0) {
            throw new KeyAgreementException("missing hash function");
        }
        this.srp = SRP.instance(string);
        this.I = (String)map.get("gnu.crypto.srp6.ka.I");
        if (this.I == null) {
            throw new KeyAgreementException("missing user identity");
        }
        this.p = (byte[])map.get("gnu.crypto.srp6.ka.p");
        if (this.p == null) {
            throw new KeyAgreementException("missing user password");
        }
    }

    protected OutgoingMessage engineProcessMessage(IncomingMessage incomingMessage) throws KeyAgreementException {
        switch (this.step) {
            case 0: {
                return this.sendIdentity(incomingMessage);
            }
            case 1: {
                return this.computeSharedSecret(incomingMessage);
            }
        }
        throw new IllegalStateException("unexpected state");
    }

    protected void engineReset() {
        this.I = null;
        this.p = null;
        this.userKeyPair = null;
        super.engineReset();
    }

    private OutgoingMessage sendIdentity(IncomingMessage incomingMessage) throws KeyAgreementException {
        SRPKeyPairGenerator sRPKeyPairGenerator = new SRPKeyPairGenerator();
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        if (this.rnd != null) {
            hashMap.put("gnu.crypto.srp.prng", this.rnd);
        }
        hashMap.put("gnu.crypto.srp.N", this.N);
        hashMap.put("gnu.crypto.srp.g", this.g);
        sRPKeyPairGenerator.setup(hashMap);
        this.userKeyPair = sRPKeyPairGenerator.generate();
        OutgoingMessage outgoingMessage = new OutgoingMessage();
        outgoingMessage.writeString(this.I);
        outgoingMessage.writeMPI(((SRPPublicKey)this.userKeyPair.getPublic()).getY());
        return outgoingMessage;
    }

    private OutgoingMessage computeSharedSecret(IncomingMessage incomingMessage) throws KeyAgreementException {
        BigInteger bigInteger;
        BigInteger bigInteger2 = incomingMessage.readMPI();
        BigInteger bigInteger3 = incomingMessage.readMPI();
        BigInteger bigInteger4 = ((SRPPublicKey)this.userKeyPair.getPublic()).getY();
        BigInteger bigInteger5 = this.uValue(bigInteger4, bigInteger3);
        try {
            bigInteger = new BigInteger(1, this.srp.computeX(Util.trim(bigInteger2), this.I, this.p));
        }
        catch (Exception exception) {
            throw new KeyAgreementException("computeSharedSecret()", exception);
        }
        BigInteger bigInteger6 = ((SRPPrivateKey)this.userKeyPair.getPrivate()).getX();
        BigInteger bigInteger7 = bigInteger3.subtract(THREE.multiply(this.g.modPow(bigInteger, this.N))).modPow(bigInteger6.add(bigInteger5.multiply(bigInteger)), this.N);
        byte[] byArray = Util.trim(bigInteger7);
        IMessageDigest iMessageDigest = this.srp.newDigest();
        iMessageDigest.update(byArray, 0, byArray.length);
        this.K = new BigInteger(1, iMessageDigest.digest());
        this.complete = true;
        return null;
    }
}

