/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.key.srp6;

import gnu.java.security.util.Util;
import gnu.javax.crypto.key.IncomingMessage;
import gnu.javax.crypto.key.KeyAgreementException;
import gnu.javax.crypto.key.OutgoingMessage;
import gnu.javax.crypto.key.srp6.SRP6KeyAgreement;
import gnu.javax.crypto.key.srp6.SRPKeyPairGenerator;
import gnu.javax.crypto.key.srp6.SRPPrivateKey;
import gnu.javax.crypto.key.srp6.SRPPublicKey;
import gnu.javax.crypto.sasl.srp.SRP;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;

public class SRP6TLSClient
extends SRP6KeyAgreement {
    private String I;
    private byte[] p;
    private KeyPair userKeyPair;

    protected void engineInit(Map map) throws KeyAgreementException {
        this.rnd = (SecureRandom)map.get("gnu.crypto.srp6.ka.prng");
        String string = (String)map.get("gnu.crypto.srp6.ka.H");
        if (string == null || string.trim().length() == 0) {
            throw new KeyAgreementException("missing hash function");
        }
        this.srp = SRP.instance(string);
        this.I = (String)map.get("gnu.crypto.srp6.ka.I");
        if (this.I == null) {
            throw new KeyAgreementException("missing user identity");
        }
        this.p = (byte[])map.get("gnu.crypto.srp6.ka.p");
        if (this.p == null) {
            throw new KeyAgreementException("missing user password");
        }
    }

    protected OutgoingMessage engineProcessMessage(IncomingMessage incomingMessage) throws KeyAgreementException {
        switch (this.step) {
            case 0: {
                return this.sendIdentity(incomingMessage);
            }
            case 1: {
                return this.computeSharedSecret(incomingMessage);
            }
        }
        throw new IllegalStateException("unexpected state");
    }

    protected void engineReset() {
        this.I = null;
        this.p = null;
        this.userKeyPair = null;
        super.engineReset();
    }

    private OutgoingMessage sendIdentity(IncomingMessage incomingMessage) throws KeyAgreementException {
        OutgoingMessage outgoingMessage = new OutgoingMessage();
        outgoingMessage.writeString(this.I);
        return outgoingMessage;
    }

    protected OutgoingMessage computeSharedSecret(IncomingMessage incomingMessage) throws KeyAgreementException {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        this.N = incomingMessage.readMPI();
        this.g = incomingMessage.readMPI();
        BigInteger bigInteger3 = incomingMessage.readMPI();
        BigInteger bigInteger4 = incomingMessage.readMPI();
        SRPKeyPairGenerator sRPKeyPairGenerator = new SRPKeyPairGenerator();
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        if (this.rnd != null) {
            hashMap.put("gnu.crypto.srp.prng", this.rnd);
        }
        hashMap.put("gnu.crypto.srp.N", this.N);
        hashMap.put("gnu.crypto.srp.g", this.g);
        sRPKeyPairGenerator.setup(hashMap);
        this.userKeyPair = sRPKeyPairGenerator.generate();
        BigInteger bigInteger5 = ((SRPPublicKey)this.userKeyPair.getPublic()).getY();
        BigInteger bigInteger6 = this.uValue(bigInteger5, bigInteger4);
        try {
            bigInteger2 = new BigInteger(1, this.srp.computeX(Util.trim(bigInteger3), this.I, this.p));
        }
        catch (Exception exception) {
            throw new KeyAgreementException("computeSharedSecret()", exception);
        }
        BigInteger bigInteger7 = ((SRPPrivateKey)this.userKeyPair.getPrivate()).getX();
        this.K = bigInteger = bigInteger4.subtract(THREE.multiply(this.g.modPow(bigInteger2, this.N))).modPow(bigInteger7.add(bigInteger6.multiply(bigInteger2)), this.N);
        OutgoingMessage outgoingMessage = new OutgoingMessage();
        outgoingMessage.writeMPI(bigInteger5);
        this.complete = true;
        return outgoingMessage;
    }
}

