/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.key.dh;

import gnu.java.security.key.IKeyPairGenerator;
import gnu.java.security.util.PRNG;
import gnu.javax.crypto.key.dh.GnuDHPrivateKey;
import gnu.javax.crypto.key.dh.GnuDHPublicKey;
import gnu.javax.crypto.key.dh.RFC2631;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.util.Map;
import java.util.logging.Logger;
import javax.crypto.spec.DHGenParameterSpec;
import javax.crypto.spec.DHParameterSpec;

public class GnuDHKeyPairGenerator
implements IKeyPairGenerator {
    private static final Logger log = null;
    public static final String SOURCE_OF_RANDOMNESS = "gnu.crypto.dh.prng";
    public static final String DH_PARAMETERS = "gnu.crypto.dh.params";
    public static final String PRIME_SIZE = "gnu.crypto.dh.L";
    public static final String EXPONENT_SIZE = "gnu.crypto.dh.m";
    public static final String PREFERRED_ENCODING_FORMAT = "gnu.crypto.dh.encoding";
    public static final int DEFAULT_PRIME_SIZE = 512;
    public static final int DEFAULT_EXPONENT_SIZE = 160;
    private static final int DEFAULT_ENCODING_FORMAT = 1;
    private SecureRandom rnd;
    private int l;
    private int m;
    private BigInteger seed;
    private BigInteger counter;
    private BigInteger q;
    private BigInteger p;
    private BigInteger j;
    private BigInteger g;
    private PRNG prng = null;
    private int preferredFormat;

    public String name() {
        return "dh";
    }

    public void setup(Map map) {
        Object object;
        this.rnd = (SecureRandom)map.get(SOURCE_OF_RANDOMNESS);
        Object v = map.get(DH_PARAMETERS);
        if (v instanceof DHGenParameterSpec) {
            object = (DHGenParameterSpec)v;
            this.l = ((DHGenParameterSpec)object).getPrimeSize();
            this.m = ((DHGenParameterSpec)object).getExponentSize();
        } else if (v instanceof DHParameterSpec) {
            object = (DHParameterSpec)v;
            this.p = ((DHParameterSpec)object).getP();
            this.g = ((DHParameterSpec)object).getG();
            this.l = this.p.bitLength();
            this.m = ((DHParameterSpec)object).getL();
            if (this.m == 0) {
                this.m = this.l;
            }
        } else {
            object = (Integer)map.get(PRIME_SIZE);
            this.l = object == null ? 512 : (Integer)object;
            object = (Integer)map.get(EXPONENT_SIZE);
            int n = this.m = object == null ? 160 : (Integer)object;
        }
        if (this.l % 256 != 0 || this.l < 512) {
            throw new IllegalArgumentException("invalid modulus size");
        }
        if (this.m % 8 != 0 || this.m < 160) {
            throw new IllegalArgumentException("invalid exponent size");
        }
        if (this.m > this.l) {
            throw new IllegalArgumentException("exponent size > modulus size");
        }
        object = (Integer)map.get(PREFERRED_ENCODING_FORMAT);
        this.preferredFormat = object == null ? 1 : (Integer)object;
    }

    public KeyPair generate() {
        BigInteger bigInteger;
        BigInteger[] bigIntegerArray;
        if (this.p == null) {
            bigIntegerArray = new RFC2631(this.m, this.l, this.rnd).generateParameters();
            this.seed = bigIntegerArray[0];
            this.counter = bigIntegerArray[1];
            this.q = bigIntegerArray[2];
            this.p = bigIntegerArray[3];
            this.j = bigIntegerArray[4];
            this.g = bigIntegerArray[5];
        }
        bigIntegerArray = null;
        if (this.q != null) {
            bigIntegerArray = this.q.subtract(BigInteger.ONE);
        }
        byte[] byArray = new byte[(this.m + 7) / 8];
        do {
            this.nextRandomBytes(byArray);
        } while ((bigInteger = new BigInteger(1, byArray)).bitLength() != this.m || bigInteger.compareTo(BigInteger.ONE) <= 0 || bigIntegerArray != null && bigInteger.compareTo((BigInteger)bigIntegerArray) >= 0);
        BigInteger bigInteger2 = this.g.modPow(bigInteger, this.p);
        GnuDHPrivateKey gnuDHPrivateKey = new GnuDHPrivateKey(this.preferredFormat, this.q, this.p, this.g, bigInteger);
        GnuDHPublicKey gnuDHPublicKey = new GnuDHPublicKey(this.preferredFormat, this.q, this.p, this.g, bigInteger2);
        return new KeyPair(gnuDHPublicKey, gnuDHPrivateKey);
    }

    private void nextRandomBytes(byte[] byArray) {
        if (this.rnd != null) {
            this.rnd.nextBytes(byArray);
        } else {
            this.getDefaultPRNG().nextBytes(byArray);
        }
    }

    private PRNG getDefaultPRNG() {
        if (this.prng == null) {
            this.prng = PRNG.getInstance();
        }
        return this.prng;
    }
}

