/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.key.dh;

import gnu.java.security.action.GetPropertyAction;
import gnu.java.security.util.FormatUtil;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.Key;
import javax.crypto.interfaces.DHKey;
import javax.crypto.spec.DHParameterSpec;

public abstract class GnuDHKey
implements Key,
DHKey {
    protected BigInteger q;
    protected BigInteger p;
    protected BigInteger g;
    protected final int defaultFormat;
    private transient String str;

    protected GnuDHKey(int n, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        this.defaultFormat = n <= 0 ? 1 : n;
        this.q = bigInteger;
        this.p = bigInteger2;
        this.g = bigInteger3;
    }

    public DHParameterSpec getParams() {
        if (this.q == null) {
            return new DHParameterSpec(this.p, this.g);
        }
        return new DHParameterSpec(this.p, this.g, this.q.bitLength());
    }

    public String getAlgorithm() {
        return "dh";
    }

    public byte[] getEncoded() {
        return this.getEncoded(this.defaultFormat);
    }

    public String getFormat() {
        return FormatUtil.getEncodingShortName(this.defaultFormat);
    }

    public BigInteger getQ() {
        return this.q;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof DHKey)) {
            return false;
        }
        DHKey dHKey = (DHKey)object;
        return this.p.equals(dHKey.getParams().getP()) && this.g.equals(dHKey.getParams().getG());
    }

    public String toString() {
        if (this.str == null) {
            String string = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
            StringBuilder stringBuilder = new StringBuilder(string).append("defaultFormat=").append(this.defaultFormat).append(",").append(string);
            if (this.q == null) {
                stringBuilder.append("q=null,");
            } else {
                stringBuilder.append("q=0x").append(this.q.toString(16)).append(",");
            }
            stringBuilder.append(string).append("p=0x").append(this.p.toString(16)).append(",").append(string).append("g=0x").append(this.g.toString(16));
            this.str = stringBuilder.toString();
        }
        return this.str;
    }

    public abstract byte[] getEncoded(int var1);
}

