/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.key.dh;

import gnu.javax.crypto.key.IncomingMessage;
import gnu.javax.crypto.key.KeyAgreementException;
import gnu.javax.crypto.key.OutgoingMessage;
import gnu.javax.crypto.key.dh.ElGamalKeyAgreement;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Map;
import javax.crypto.interfaces.DHPrivateKey;

public class ElGamalReceiver
extends ElGamalKeyAgreement {
    private DHPrivateKey B;

    protected void engineInit(Map map) throws KeyAgreementException {
        this.rnd = (SecureRandom)map.get("gnu.crypto.elgamal.ka.prng");
        this.B = (DHPrivateKey)map.get("gnu.crypto.elgamal.ka.recipient.private.key");
        if (this.B == null) {
            throw new KeyAgreementException("missing recipient private key");
        }
    }

    protected OutgoingMessage engineProcessMessage(IncomingMessage incomingMessage) throws KeyAgreementException {
        switch (this.step) {
            case 0: {
                return this.computeSharedSecret(incomingMessage);
            }
        }
        throw new IllegalStateException("unexpected state");
    }

    private OutgoingMessage computeSharedSecret(IncomingMessage incomingMessage) throws KeyAgreementException {
        BigInteger bigInteger = incomingMessage.readMPI();
        if (bigInteger == null) {
            throw new KeyAgreementException("missing message (1)");
        }
        this.ZZ = bigInteger.modPow(this.B.getX(), this.B.getParams().getP());
        this.complete = true;
        return null;
    }
}

