/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.key.dh;

import gnu.java.security.prng.IRandom;
import gnu.javax.crypto.key.IncomingMessage;
import gnu.javax.crypto.key.KeyAgreementException;
import gnu.javax.crypto.key.OutgoingMessage;
import gnu.javax.crypto.key.dh.DiffieHellmanKeyAgreement;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Map;
import javax.crypto.interfaces.DHPrivateKey;

public class DiffieHellmanSender
extends DiffieHellmanKeyAgreement {
    private BigInteger x;

    protected void engineInit(Map map) throws KeyAgreementException {
        Object v = map.get("gnu.crypto.dh.ka.prng");
        this.rnd = null;
        this.irnd = null;
        if (v instanceof SecureRandom) {
            this.rnd = (SecureRandom)v;
        } else if (v instanceof IRandom) {
            this.irnd = (IRandom)v;
        }
        this.ownerKey = (DHPrivateKey)map.get("gnu.crypto.dh.ka.owner.private.key");
        if (this.ownerKey == null) {
            throw new KeyAgreementException("missing owner's private key");
        }
    }

    protected OutgoingMessage engineProcessMessage(IncomingMessage incomingMessage) throws KeyAgreementException {
        switch (this.step) {
            case 0: {
                return this.sendRandomSecret(incomingMessage);
            }
            case 1: {
                return this.computeSharedSecret(incomingMessage);
            }
        }
        throw new IllegalStateException("unexpected state");
    }

    private OutgoingMessage sendRandomSecret(IncomingMessage incomingMessage) throws KeyAgreementException {
        BigInteger bigInteger = this.ownerKey.getParams().getP();
        BigInteger bigInteger2 = this.ownerKey.getParams().getG();
        BigInteger bigInteger3 = bigInteger.subtract(TWO);
        byte[] byArray = new byte[(bigInteger3.bitLength() + 7) / 8];
        do {
            this.nextRandomBytes(byArray);
            this.x = new BigInteger(1, byArray);
        } while (this.x.compareTo(TWO) < 0 || this.x.compareTo(bigInteger3) > 0);
        OutgoingMessage outgoingMessage = new OutgoingMessage();
        outgoingMessage.writeMPI(bigInteger2.modPow(this.x, bigInteger));
        return outgoingMessage;
    }

    private OutgoingMessage computeSharedSecret(IncomingMessage incomingMessage) throws KeyAgreementException {
        BigInteger bigInteger = incomingMessage.readMPI();
        if (bigInteger == null) {
            throw new KeyAgreementException("missing message (2)");
        }
        BigInteger bigInteger2 = this.ownerKey.getParams().getP();
        this.ZZ = bigInteger.modPow(this.x, bigInteger2);
        this.complete = true;
        return null;
    }
}

