/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.key.dh;

import gnu.java.security.OID;
import gnu.java.security.der.BitString;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.der.DERWriter;
import gnu.java.security.key.IKeyPairCodec;
import gnu.java.security.util.DerUtil;
import gnu.javax.crypto.key.dh.GnuDHPublicKey;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;

public class DHKeyPairX509Codec
implements IKeyPairCodec {
    private static final OID DH_ALG_OID = new OID("1.2.840.10046.2.1");

    public int getFormatID() {
        return 2;
    }

    public byte[] encodePublicKey(PublicKey publicKey) {
        byte[] byArray;
        if (!(publicKey instanceof GnuDHPublicKey)) {
            throw new InvalidParameterException("Wrong key type");
        }
        DERValue dERValue = new DERValue(6, DH_ALG_OID);
        GnuDHPublicKey gnuDHPublicKey = (GnuDHPublicKey)publicKey;
        BigInteger bigInteger = gnuDHPublicKey.getParams().getP();
        BigInteger bigInteger2 = gnuDHPublicKey.getParams().getG();
        BigInteger bigInteger3 = gnuDHPublicKey.getQ();
        if (bigInteger3 == null) {
            bigInteger3 = BigInteger.ZERO;
        }
        BigInteger bigInteger4 = gnuDHPublicKey.getY();
        DERValue dERValue2 = new DERValue(2, bigInteger);
        DERValue dERValue3 = new DERValue(2, bigInteger2);
        DERValue dERValue4 = new DERValue(2, bigInteger3);
        ArrayList<DERValue> arrayList = new ArrayList<DERValue>(3);
        arrayList.add(dERValue2);
        arrayList.add(dERValue3);
        arrayList.add(dERValue4);
        DERValue dERValue5 = new DERValue(48, arrayList);
        ArrayList<DERValue> arrayList2 = new ArrayList<DERValue>(2);
        arrayList2.add(dERValue);
        arrayList2.add(dERValue5);
        DERValue dERValue6 = new DERValue(48, arrayList2);
        DERValue dERValue7 = new DERValue(2, bigInteger4);
        byte[] byArray2 = dERValue7.getEncoded();
        DERValue dERValue8 = new DERValue(3, new BitString(byArray2));
        ArrayList<DERValue> arrayList3 = new ArrayList<DERValue>(2);
        arrayList3.add(dERValue6);
        arrayList3.add(dERValue8);
        DERValue dERValue9 = new DERValue(48, arrayList3);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            DERWriter.write(byteArrayOutputStream, dERValue9);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            InvalidParameterException invalidParameterException = new InvalidParameterException();
            invalidParameterException.initCause(iOException);
            throw invalidParameterException;
        }
        return byArray;
    }

    public byte[] encodePrivateKey(PrivateKey privateKey) {
        throw new InvalidParameterException("Wrong format for private keys");
    }

    public PublicKey decodePublicKey(byte[] byArray) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        if (byArray == null) {
            throw new InvalidParameterException("Input bytes MUST NOT be null");
        }
        DERReader dERReader = new DERReader(byArray);
        try {
            DERValue dERValue = dERReader.read();
            DerUtil.checkIsConstructed(dERValue, "Wrong SubjectPublicKeyInfo field");
            DERValue dERValue2 = dERReader.read();
            DerUtil.checkIsConstructed(dERValue2, "Wrong AlgorithmIdentifier field");
            DERValue dERValue3 = dERReader.read();
            if (!(dERValue3.getValue() instanceof OID)) {
                throw new InvalidParameterException("Wrong Algorithm field");
            }
            OID oID = (OID)dERValue3.getValue();
            if (!oID.equals(DH_ALG_OID)) {
                throw new InvalidParameterException("Unexpected OID: " + oID);
            }
            DERValue dERValue4 = dERReader.read();
            DerUtil.checkIsConstructed(dERValue4, "Wrong DH Parameters field");
            DERValue dERValue5 = dERReader.read();
            DerUtil.checkIsBigInteger(dERValue5, "Wrong P field");
            bigInteger4 = (BigInteger)dERValue5.getValue();
            dERValue5 = dERReader.read();
            DerUtil.checkIsBigInteger(dERValue5, "Wrong G field");
            bigInteger3 = (BigInteger)dERValue5.getValue();
            dERValue5 = dERReader.read();
            DerUtil.checkIsBigInteger(dERValue5, "Wrong Q field");
            bigInteger2 = (BigInteger)dERValue5.getValue();
            if (bigInteger2.compareTo(BigInteger.ZERO) == 0) {
                bigInteger2 = null;
            }
            if (!((dERValue5 = dERReader.read()).getValue() instanceof BitString)) {
                throw new InvalidParameterException("Wrong SubjectPublicKey field");
            }
            byte[] byArray2 = ((BitString)dERValue5.getValue()).toByteArray();
            DERReader dERReader2 = new DERReader(byArray2);
            dERValue5 = dERReader2.read();
            DerUtil.checkIsBigInteger(dERValue5, "Wrong Y field");
            bigInteger = (BigInteger)dERValue5.getValue();
        }
        catch (IOException iOException) {
            InvalidParameterException invalidParameterException = new InvalidParameterException();
            invalidParameterException.initCause(iOException);
            throw invalidParameterException;
        }
        return new GnuDHPublicKey(2, bigInteger2, bigInteger4, bigInteger3, bigInteger);
    }

    public PrivateKey decodePrivateKey(byte[] byArray) {
        throw new InvalidParameterException("Wrong format for private keys");
    }
}

