/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.key;

import gnu.javax.crypto.key.BaseKeyAgreementParty;
import gnu.javax.crypto.key.IKeyAgreementParty;
import gnu.javax.crypto.key.dh.DiffieHellmanReceiver;
import gnu.javax.crypto.key.dh.DiffieHellmanSender;
import gnu.javax.crypto.key.dh.ElGamalReceiver;
import gnu.javax.crypto.key.dh.ElGamalSender;
import gnu.javax.crypto.key.srp6.SRP6Host;
import gnu.javax.crypto.key.srp6.SRP6SaslClient;
import gnu.javax.crypto.key.srp6.SRP6SaslServer;
import gnu.javax.crypto.key.srp6.SRP6TLSClient;
import gnu.javax.crypto.key.srp6.SRP6TLSServer;
import gnu.javax.crypto.key.srp6.SRP6User;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class KeyAgreementFactory {
    private KeyAgreementFactory() {
    }

    public static IKeyAgreementParty getPartyAInstance(String string) {
        if (string == null) {
            return null;
        }
        string = string.trim();
        BaseKeyAgreementParty baseKeyAgreementParty = null;
        if (string.equalsIgnoreCase("dh")) {
            baseKeyAgreementParty = new DiffieHellmanSender();
        } else if (string.equalsIgnoreCase("elgamal")) {
            baseKeyAgreementParty = new ElGamalSender();
        } else if (string.equalsIgnoreCase("srp6")) {
            baseKeyAgreementParty = new SRP6User();
        } else if (string.equalsIgnoreCase("srp-sasl")) {
            baseKeyAgreementParty = new SRP6SaslClient();
        } else if (string.equalsIgnoreCase("srp-tls")) {
            baseKeyAgreementParty = new SRP6TLSClient();
        }
        return baseKeyAgreementParty;
    }

    public static IKeyAgreementParty getPartyBInstance(String string) {
        if (string == null) {
            return null;
        }
        string = string.trim();
        BaseKeyAgreementParty baseKeyAgreementParty = null;
        if (string.equalsIgnoreCase("dh")) {
            baseKeyAgreementParty = new DiffieHellmanReceiver();
        } else if (string.equalsIgnoreCase("elgamal")) {
            baseKeyAgreementParty = new ElGamalReceiver();
        } else if (string.equalsIgnoreCase("srp6")) {
            baseKeyAgreementParty = new SRP6Host();
        } else if (string.equalsIgnoreCase("srp-sasl")) {
            baseKeyAgreementParty = new SRP6SaslServer();
        } else if (string.equalsIgnoreCase("srp-tls")) {
            baseKeyAgreementParty = new SRP6TLSServer();
        }
        return baseKeyAgreementParty;
    }

    public static final Set getNames() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("dh");
        hashSet.add("elgamal");
        hashSet.add("srp6");
        hashSet.add("srp-sasl");
        hashSet.add("srp-tls");
        return Collections.unmodifiableSet(hashSet);
    }
}

