/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.key;

import gnu.java.security.prng.IRandom;
import gnu.java.security.prng.LimitReachedException;
import gnu.java.security.util.PRNG;
import gnu.javax.crypto.key.IKeyAgreementParty;
import gnu.javax.crypto.key.IncomingMessage;
import gnu.javax.crypto.key.KeyAgreementException;
import gnu.javax.crypto.key.OutgoingMessage;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Map;

public abstract class BaseKeyAgreementParty
implements IKeyAgreementParty {
    protected static final BigInteger TWO = BigInteger.valueOf(2L);
    protected String name;
    protected boolean initialised = false;
    protected int step = -1;
    protected boolean complete = false;
    protected SecureRandom rnd = null;
    protected IRandom irnd = null;
    private PRNG prng = null;

    protected BaseKeyAgreementParty(String string) {
        this.name = string;
    }

    public String name() {
        return this.name;
    }

    public void init(Map map) throws KeyAgreementException {
        if (this.initialised) {
            throw new IllegalStateException("already initialised");
        }
        this.engineInit(map);
        this.initialised = true;
        this.step = -1;
        this.complete = false;
    }

    public OutgoingMessage processMessage(IncomingMessage incomingMessage) throws KeyAgreementException {
        if (!this.initialised) {
            throw new IllegalStateException("not initialised");
        }
        if (this.complete) {
            throw new IllegalStateException("exchange has already concluded");
        }
        ++this.step;
        return this.engineProcessMessage(incomingMessage);
    }

    public boolean isComplete() {
        return this.complete;
    }

    public byte[] getSharedSecret() throws KeyAgreementException {
        if (!this.initialised) {
            throw new KeyAgreementException("not yet initialised");
        }
        if (!this.isComplete()) {
            throw new KeyAgreementException("not yet computed");
        }
        return this.engineSharedSecret();
    }

    public void reset() {
        if (this.initialised) {
            this.engineReset();
            this.initialised = false;
        }
    }

    protected abstract void engineInit(Map var1) throws KeyAgreementException;

    protected abstract OutgoingMessage engineProcessMessage(IncomingMessage var1) throws KeyAgreementException;

    protected abstract byte[] engineSharedSecret() throws KeyAgreementException;

    protected abstract void engineReset();

    protected void nextRandomBytes(byte[] byArray) {
        if (this.rnd != null) {
            this.rnd.nextBytes(byArray);
        } else if (this.irnd != null) {
            try {
                this.irnd.nextBytes(byArray, 0, byArray.length);
            }
            catch (LimitReachedException limitReachedException) {
                this.irnd = null;
                this.getDefaultPRNG().nextBytes(byArray);
            }
        } else {
            this.getDefaultPRNG().nextBytes(byArray);
        }
    }

    private PRNG getDefaultPRNG() {
        if (this.prng == null) {
            this.prng = PRNG.getInstance();
        }
        return this.prng;
    }
}

