/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.keyring;

import gnu.java.security.Registry;
import gnu.javax.crypto.keyring.GnuPrivateKeyring;
import gnu.javax.crypto.keyring.GnuPublicKeyring;
import gnu.javax.crypto.keyring.IKeyring;
import gnu.javax.crypto.keyring.IPrivateKeyring;
import gnu.javax.crypto.keyring.IPublicKeyring;
import gnu.javax.crypto.keyring.MalformedKeyringException;
import gnu.javax.crypto.keyring.PrimitiveEntry;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.crypto.SecretKey;

public class GnuKeyring
extends KeyStoreSpi {
    private static final Logger log = null;
    private static final String NOT_LOADED = "not loaded";
    private boolean loaded;
    private IPrivateKeyring privateKR;
    private IPublicKeyring publicKR;

    public Enumeration engineAliases() {
        Enumeration enumeration;
        this.ensureLoaded();
        if (this.privateKR == null) {
            enumeration = Collections.enumeration(Collections.EMPTY_SET);
        } else {
            String string;
            HashSet hashSet = new HashSet();
            Enumeration enumeration2 = this.privateKR.aliases();
            while (enumeration2.hasMoreElements()) {
                string = (String)enumeration2.nextElement();
                if (string == null || (string = string.trim()).length() <= 0) continue;
                hashSet.add(string);
            }
            enumeration2 = this.publicKR.aliases();
            while (enumeration2.hasMoreElements()) {
                string = (String)enumeration2.nextElement();
                if (string == null || (string = string.trim()).length() <= 0) continue;
                hashSet.add(string);
            }
            enumeration = Collections.enumeration(hashSet);
        }
        return enumeration;
    }

    public boolean engineContainsAlias(String string) {
        this.ensureLoaded();
        boolean bl = this.privateKR.containsAlias(string);
        boolean bl2 = this.publicKR.containsAlias(string);
        boolean bl3 = bl || bl2;
        return bl3;
    }

    public void engineDeleteEntry(String string) {
        this.ensureLoaded();
        if (this.privateKR.containsAlias(string)) {
            this.privateKR.remove(string);
        } else if (this.publicKR.containsAlias(string)) {
            this.publicKR.remove(string);
        }
    }

    public Certificate engineGetCertificate(String string) {
        this.ensureLoaded();
        Certificate certificate = this.publicKR.getCertificate(string);
        return certificate;
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        this.ensureLoaded();
        String string = null;
        Enumeration enumeration = this.publicKR.aliases();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Certificate certificate2 = this.publicKR.getCertificate(string2);
            if (!certificate.equals(certificate2)) continue;
            string = string2;
            break;
        }
        return string;
    }

    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        this.ensureLoaded();
        if (this.privateKR.containsAlias(string)) {
            throw new KeyStoreException("Alias [" + string + "] already exists and DOES NOT identify a " + "Trusted Certificate Entry");
        }
        if (this.publicKR.containsCertificate(string)) {
            this.publicKR.remove(string);
        }
        this.publicKR.putCertificate(string, certificate);
    }

    public Certificate[] engineGetCertificateChain(String string) {
        this.ensureLoaded();
        Certificate[] certificateArray = this.privateKR.getCertPath(string);
        return certificateArray;
    }

    public Date engineGetCreationDate(String string) {
        this.ensureLoaded();
        Date date = this.getCreationDate(string, this.privateKR);
        if (date == null) {
            date = this.getCreationDate(string, this.publicKR);
        }
        return date;
    }

    public Key engineGetKey(String string, char[] cArray) throws UnrecoverableKeyException {
        this.ensureLoaded();
        Key key = null;
        if (cArray == null) {
            if (this.privateKR.containsPublicKey(string)) {
                key = this.privateKR.getPublicKey(string);
            }
        } else if (this.privateKR.containsPrivateKey(string)) {
            key = this.privateKR.getPrivateKey(string, cArray);
        }
        return key;
    }

    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        this.ensureLoaded();
        if (this.publicKR.containsAlias(string)) {
            throw new KeyStoreException("Alias [" + string + "] already exists and DOES NOT identify a " + "Key Entry");
        }
        if (key instanceof PublicKey) {
            this.privateKR.remove(string);
            PublicKey publicKey = (PublicKey)key;
            this.privateKR.putPublicKey(string, publicKey);
        } else {
            if (!(key instanceof PrivateKey) && !(key instanceof SecretKey)) {
                throw new KeyStoreException("cannot store keys of type " + key.getClass().getName());
            }
            this.privateKR.remove(string);
            this.privateKR.putCertPath(string, certificateArray);
            this.privateKR.putPrivateKey(string, key, cArray);
        }
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        KeyStoreException keyStoreException = new KeyStoreException("method not supported");
        throw keyStoreException;
    }

    public boolean engineIsCertificateEntry(String string) {
        this.ensureLoaded();
        boolean bl = this.publicKR.containsCertificate(string);
        return bl;
    }

    public boolean engineIsKeyEntry(String string) {
        this.ensureLoaded();
        boolean bl = this.privateKR.containsPublicKey(string) || this.privateKR.containsPrivateKey(string);
        return bl;
    }

    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException {
        if (inputStream != null) {
            if (!inputStream.markSupported()) {
                inputStream = new BufferedInputStream(inputStream);
            }
            this.loadPrivateKeyring(inputStream, cArray);
            this.loadPublicKeyring(inputStream, cArray);
        } else {
            this.createNewKeyrings();
        }
        this.loaded = true;
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException {
        this.ensureLoaded();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("gun.crypto.keyring.data.out", outputStream);
        hashMap.put("gnu.crypto.keyring.password", cArray);
        this.privateKR.store(hashMap);
        this.publicKR.store(hashMap);
    }

    public int engineSize() {
        int n = 0;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            ++n;
        }
        return n;
    }

    private void ensureLoaded() {
        if (!this.loaded) {
            throw new IllegalStateException(NOT_LOADED);
        }
    }

    private void loadPrivateKeyring(InputStream inputStream, char[] cArray) throws MalformedKeyringException, IOException {
        int n;
        inputStream.mark(5);
        for (n = 0; n < 4; ++n) {
            if (inputStream.read() == Registry.GKR_MAGIC[n]) continue;
            throw new MalformedKeyringException("incorrect magic");
        }
        n = inputStream.read();
        inputStream.reset();
        if (n != 3) {
            throw new MalformedKeyringException("Was expecting a private keyring but got a wrong USAGE: " + Integer.toBinaryString(n));
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("gnu.crypto.keyring.data.in", inputStream);
        hashMap.put("gnu.crypto.keyring.password", cArray);
        this.privateKR = new GnuPrivateKeyring();
        this.privateKR.load(hashMap);
    }

    private void loadPublicKeyring(InputStream inputStream, char[] cArray) throws MalformedKeyringException, IOException {
        int n;
        inputStream.mark(5);
        for (n = 0; n < 4; ++n) {
            if (inputStream.read() == Registry.GKR_MAGIC[n]) continue;
            throw new MalformedKeyringException("incorrect magic");
        }
        n = inputStream.read();
        inputStream.reset();
        if (n != 4) {
            throw new MalformedKeyringException("Was expecting a public keyring but got a wrong USAGE: " + Integer.toBinaryString(n));
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("gnu.crypto.keyring.data.in", inputStream);
        hashMap.put("gnu.crypto.keyring.password", cArray);
        this.publicKR = new GnuPublicKeyring();
        this.publicKR.load(hashMap);
    }

    private Date getCreationDate(String string, IKeyring iKeyring) {
        Date date = null;
        if (iKeyring != null) {
            for (Object e : iKeyring.get(string)) {
                if (!(e instanceof PrimitiveEntry)) continue;
                date = ((PrimitiveEntry)e).getCreationDate();
                break;
            }
        }
        return date;
    }

    private void createNewKeyrings() {
        this.privateKR = new GnuPrivateKeyring("HMAC-SHA-1", 20, "AES", "OFB", 16);
        this.publicKR = new GnuPublicKeyring("HMAC-SHA-1", 20);
    }
}

