/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.key;

import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.SecretKeySpec;

public abstract class SecretKeyFactoryImpl
extends SecretKeyFactorySpi {
    protected SecretKeyFactoryImpl() {
    }

    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof SecretKeySpec) {
            return (SecretKey)((Object)keySpec);
        }
        throw new InvalidKeySpecException("unknown key spec: " + keySpec.getClass().getName());
    }

    protected KeySpec engineGetKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        if (clazz.equals(SecretKeySpec.class)) {
            if (secretKey instanceof SecretKeySpec) {
                return (KeySpec)((Object)secretKey);
            }
            return new SecretKeySpec(secretKey.getEncoded(), secretKey.getAlgorithm());
        }
        throw new InvalidKeySpecException("unsupported key spec: " + clazz.getName());
    }

    protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
        if (!"RAW".equals(secretKey.getFormat())) {
            throw new InvalidKeyException("only raw keys are supported");
        }
        return new SecretKeySpec(secretKey.getEncoded(), secretKey.getAlgorithm());
    }
}

