/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.cipher;

import gnu.java.security.util.Util;
import gnu.javax.crypto.cipher.BaseCipher;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.logging.Logger;

public final class Twofish
extends BaseCipher {
    private static final Logger log;
    private static final int DEFAULT_BLOCK_SIZE = 16;
    private static final int DEFAULT_KEY_SIZE = 16;
    private static final int MAX_ROUNDS = 16;
    private static final int ROUNDS = 16;
    private static final int INPUT_WHITEN = 0;
    private static final int OUTPUT_WHITEN = 4;
    private static final int ROUND_SUBKEYS = 8;
    private static final int SK_STEP = 0x2020202;
    private static final int SK_BUMP = 0x1010101;
    private static final int SK_ROTL = 9;
    private static final String[] Pm;
    private static final byte[][] P;
    private static final int P_00 = 1;
    private static final int P_01 = 0;
    private static final int P_02 = 0;
    private static final int P_03 = 1;
    private static final int P_04 = 1;
    private static final int P_10 = 0;
    private static final int P_11 = 0;
    private static final int P_12 = 1;
    private static final int P_13 = 1;
    private static final int P_14 = 0;
    private static final int P_20 = 1;
    private static final int P_21 = 1;
    private static final int P_22 = 0;
    private static final int P_23 = 0;
    private static final int P_24 = 0;
    private static final int P_30 = 0;
    private static final int P_31 = 1;
    private static final int P_32 = 1;
    private static final int P_33 = 0;
    private static final int P_34 = 1;
    private static final int GF256_FDBK_2 = 180;
    private static final int GF256_FDBK_4 = 90;
    private static final int[][] MDS;
    private static final int RS_GF_FDBK = 333;
    private static final byte[] KAT_KEY;
    private static final byte[] KAT_CT;
    private static Boolean valid;

    private static final int LFSR1(int n) {
        return n >> 1 ^ ((n & 1) != 0 ? 180 : 0);
    }

    private static final int LFSR2(int n) {
        return n >> 2 ^ ((n & 2) != 0 ? 180 : 0) ^ ((n & 1) != 0 ? 90 : 0);
    }

    private static final int Mx_X(int n) {
        return n ^ Twofish.LFSR2(n);
    }

    private static final int Mx_Y(int n) {
        return n ^ Twofish.LFSR1(n) ^ Twofish.LFSR2(n);
    }

    public Twofish() {
        super("twofish", 16, 16);
    }

    private static final int b0(int n) {
        return n & 0xFF;
    }

    private static final int b1(int n) {
        return n >>> 8 & 0xFF;
    }

    private static final int b2(int n) {
        return n >>> 16 & 0xFF;
    }

    private static final int b3(int n) {
        return n >>> 24 & 0xFF;
    }

    private static final int RS_MDS_Encode(int n, int n2) {
        int n3;
        int n4 = n2;
        for (n3 = 0; n3 < 4; ++n3) {
            n4 = Twofish.RS_rem(n4);
        }
        n4 ^= n;
        for (n3 = 0; n3 < 4; ++n3) {
            n4 = Twofish.RS_rem(n4);
        }
        return n4;
    }

    private static final int RS_rem(int n) {
        int n2;
        int n3 = (n2 << 1 ^ (((n2 = n >>> 24 & 0xFF) & 0x80) != 0 ? 333 : 0)) & 0xFF;
        int n4 = n2 >>> 1 ^ ((n2 & 1) != 0 ? 166 : 0) ^ n3;
        int n5 = n << 8 ^ n4 << 24 ^ n3 << 16 ^ n4 << 8 ^ n2;
        return n5;
    }

    private static final int F32(int n, int n2, int[] nArray) {
        int n3 = Twofish.b0(n2);
        int n4 = Twofish.b1(n2);
        int n5 = Twofish.b2(n2);
        int n6 = Twofish.b3(n2);
        int n7 = nArray[0];
        int n8 = nArray[1];
        int n9 = nArray[2];
        int n10 = nArray[3];
        int n11 = 0;
        switch (n & 3) {
            case 1: {
                n11 = MDS[0][P[0][n3] & 0xFF ^ Twofish.b0(n7)] ^ MDS[1][P[0][n4] & 0xFF ^ Twofish.b1(n7)] ^ MDS[2][P[1][n5] & 0xFF ^ Twofish.b2(n7)] ^ MDS[3][P[1][n6] & 0xFF ^ Twofish.b3(n7)];
                break;
            }
            case 0: {
                n3 = P[1][n3] & 0xFF ^ Twofish.b0(n10);
                n4 = P[0][n4] & 0xFF ^ Twofish.b1(n10);
                n5 = P[0][n5] & 0xFF ^ Twofish.b2(n10);
                n6 = P[1][n6] & 0xFF ^ Twofish.b3(n10);
            }
            case 3: {
                n3 = P[1][n3] & 0xFF ^ Twofish.b0(n9);
                n4 = P[1][n4] & 0xFF ^ Twofish.b1(n9);
                n5 = P[0][n5] & 0xFF ^ Twofish.b2(n9);
                n6 = P[0][n6] & 0xFF ^ Twofish.b3(n9);
            }
            case 2: {
                n11 = MDS[0][P[0][P[0][n3] & 0xFF ^ Twofish.b0(n8)] & 0xFF ^ Twofish.b0(n7)] ^ MDS[1][P[0][P[1][n4] & 0xFF ^ Twofish.b1(n8)] & 0xFF ^ Twofish.b1(n7)] ^ MDS[2][P[1][P[0][n5] & 0xFF ^ Twofish.b2(n8)] & 0xFF ^ Twofish.b2(n7)] ^ MDS[3][P[1][P[1][n6] & 0xFF ^ Twofish.b3(n8)] & 0xFF ^ Twofish.b3(n7)];
            }
        }
        return n11;
    }

    private static final int Fe32(int[] nArray, int n, int n2) {
        return nArray[2 * Twofish._b(n, n2)] ^ nArray[2 * Twofish._b(n, n2 + 1) + 1] ^ nArray[512 + 2 * Twofish._b(n, n2 + 2)] ^ nArray[512 + 2 * Twofish._b(n, n2 + 3) + 1];
    }

    private static final int _b(int n, int n2) {
        switch (n2 % 4) {
            case 0: {
                return n & 0xFF;
            }
            case 1: {
                return n >>> 8 & 0xFF;
            }
            case 2: {
                return n >>> 16 & 0xFF;
            }
        }
        return n >>> 24;
    }

    public Object clone() {
        Twofish twofish = new Twofish();
        twofish.currentBlockSize = this.currentBlockSize;
        return twofish;
    }

    public Iterator blockSizes() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(16);
        return Collections.unmodifiableList(arrayList).iterator();
    }

    public Iterator keySizes() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(8);
        arrayList.add(16);
        arrayList.add(24);
        arrayList.add(32);
        return Collections.unmodifiableList(arrayList).iterator();
    }

    public Object makeKey(byte[] byArray, int n) throws InvalidKeyException {
        if (n != 16) {
            throw new IllegalArgumentException();
        }
        if (byArray == null) {
            throw new InvalidKeyException("Empty key");
        }
        int n2 = byArray.length;
        if (n2 != 8 && n2 != 16 && n2 != 24 && n2 != 32) {
            throw new InvalidKeyException("Incorrect key length");
        }
        int n3 = n2 / 8;
        int n4 = 40;
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        int[] nArray3 = new int[4];
        int n5 = 0;
        int n6 = 0;
        int n7 = n3 - 1;
        while (n6 < 4 && n5 < n2) {
            nArray[n6] = byArray[n5++] & 0xFF | (byArray[n5++] & 0xFF) << 8 | (byArray[n5++] & 0xFF) << 16 | (byArray[n5++] & 0xFF) << 24;
            nArray2[n6] = byArray[n5++] & 0xFF | (byArray[n5++] & 0xFF) << 8 | (byArray[n5++] & 0xFF) << 16 | (byArray[n5++] & 0xFF) << 24;
            nArray3[n7] = Twofish.RS_MDS_Encode(nArray[n6], nArray2[n6]);
            ++n6;
            --n7;
        }
        int[] nArray4 = new int[n4];
        int n8 = 0;
        n6 = 0;
        while (n6 < n4 / 2) {
            int n9 = Twofish.F32(n3, n8, nArray);
            int n10 = Twofish.F32(n3, n8 + 0x1010101, nArray2);
            n10 = n10 << 8 | n10 >>> 24;
            nArray4[2 * n6] = n9 += n10;
            nArray4[2 * n6 + 1] = (n9 += n10) << 9 | n9 >>> 23;
            ++n6;
            n8 += 0x2020202;
        }
        int n11 = nArray3[0];
        int n12 = nArray3[1];
        int n13 = nArray3[2];
        int n14 = nArray3[3];
        int[] nArray5 = new int[1024];
        block8: for (n6 = 0; n6 < 256; ++n6) {
            int n15;
            int n16 = n15 = n6;
            int n17 = n15;
            int n18 = n15;
            switch (n3 & 3) {
                case 1: {
                    nArray5[2 * n6] = MDS[0][P[0][n18] & 0xFF ^ Twofish.b0(n11)];
                    nArray5[2 * n6 + 1] = MDS[1][P[0][n17] & 0xFF ^ Twofish.b1(n11)];
                    nArray5[512 + 2 * n6] = MDS[2][P[1][n16] & 0xFF ^ Twofish.b2(n11)];
                    nArray5[512 + 2 * n6 + 1] = MDS[3][P[1][n15] & 0xFF ^ Twofish.b3(n11)];
                    continue block8;
                }
                case 0: {
                    n18 = P[1][n18] & 0xFF ^ Twofish.b0(n14);
                    n17 = P[0][n17] & 0xFF ^ Twofish.b1(n14);
                    n16 = P[0][n16] & 0xFF ^ Twofish.b2(n14);
                    n15 = P[1][n15] & 0xFF ^ Twofish.b3(n14);
                }
                case 3: {
                    n18 = P[1][n18] & 0xFF ^ Twofish.b0(n13);
                    n17 = P[1][n17] & 0xFF ^ Twofish.b1(n13);
                    n16 = P[0][n16] & 0xFF ^ Twofish.b2(n13);
                    n15 = P[0][n15] & 0xFF ^ Twofish.b3(n13);
                }
                case 2: {
                    nArray5[2 * n6] = MDS[0][P[0][P[0][n18] & 0xFF ^ Twofish.b0(n12)] & 0xFF ^ Twofish.b0(n11)];
                    nArray5[2 * n6 + 1] = MDS[1][P[0][P[1][n17] & 0xFF ^ Twofish.b1(n12)] & 0xFF ^ Twofish.b1(n11)];
                    nArray5[512 + 2 * n6] = MDS[2][P[1][P[0][n16] & 0xFF ^ Twofish.b2(n12)] & 0xFF ^ Twofish.b2(n11)];
                    nArray5[512 + 2 * n6 + 1] = MDS[3][P[1][P[1][n15] & 0xFF ^ Twofish.b3(n12)] & 0xFF ^ Twofish.b3(n11)];
                }
            }
        }
        return new Object[]{nArray5, nArray4};
    }

    public void encrypt(byte[] byArray, int n, byte[] byArray2, int n2, Object object, int n3) {
        if (n3 != 16) {
            throw new IllegalArgumentException();
        }
        Object[] objectArray = (Object[])object;
        int[] nArray = (int[])objectArray[0];
        int[] nArray2 = (int[])objectArray[1];
        int n4 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n5 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n6 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n7 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        n4 ^= nArray2[0];
        n5 ^= nArray2[1];
        n6 ^= nArray2[2];
        n7 ^= nArray2[3];
        int n8 = 8;
        for (int i = 0; i < 16; i += 2) {
            int n9 = Twofish.Fe32(nArray, n4, 0);
            int n10 = Twofish.Fe32(nArray, n5, 3);
            n6 ^= n9 + n10 + nArray2[n8++];
            n6 = n6 >>> 1 | n6 << 31;
            n7 = n7 << 1 | n7 >>> 31;
            n7 ^= n9 + 2 * n10 + nArray2[n8++];
            n9 = Twofish.Fe32(nArray, n6, 0);
            n10 = Twofish.Fe32(nArray, n7, 3);
            n4 ^= n9 + n10 + nArray2[n8++];
            n4 = n4 >>> 1 | n4 << 31;
            n5 = n5 << 1 | n5 >>> 31;
            n5 ^= n9 + 2 * n10 + nArray2[n8++];
        }
        n7 ^= nArray2[5];
        n4 ^= nArray2[6];
        n5 ^= nArray2[7];
        byArray2[n2++] = (byte)(n6 ^= nArray2[4]);
        byArray2[n2++] = (byte)(n6 >>> 8);
        byArray2[n2++] = (byte)(n6 >>> 16);
        byArray2[n2++] = (byte)(n6 >>> 24);
        byArray2[n2++] = (byte)n7;
        byArray2[n2++] = (byte)(n7 >>> 8);
        byArray2[n2++] = (byte)(n7 >>> 16);
        byArray2[n2++] = (byte)(n7 >>> 24);
        byArray2[n2++] = (byte)n4;
        byArray2[n2++] = (byte)(n4 >>> 8);
        byArray2[n2++] = (byte)(n4 >>> 16);
        byArray2[n2++] = (byte)(n4 >>> 24);
        byArray2[n2++] = (byte)n5;
        byArray2[n2++] = (byte)(n5 >>> 8);
        byArray2[n2++] = (byte)(n5 >>> 16);
        byArray2[n2] = (byte)(n5 >>> 24);
    }

    public void decrypt(byte[] byArray, int n, byte[] byArray2, int n2, Object object, int n3) {
        if (n3 != 16) {
            throw new IllegalArgumentException();
        }
        Object[] objectArray = (Object[])object;
        int[] nArray = (int[])objectArray[0];
        int[] nArray2 = (int[])objectArray[1];
        int n4 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n5 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n6 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n7 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        n4 ^= nArray2[4];
        n5 ^= nArray2[5];
        n6 ^= nArray2[6];
        n7 ^= nArray2[7];
        int n8 = 39;
        for (int i = 0; i < 16; i += 2) {
            int n9 = Twofish.Fe32(nArray, n4, 0);
            int n10 = Twofish.Fe32(nArray, n5, 3);
            n7 ^= n9 + 2 * n10 + nArray2[n8--];
            n7 = n7 >>> 1 | n7 << 31;
            n6 = n6 << 1 | n6 >>> 31;
            n6 ^= n9 + n10 + nArray2[n8--];
            n9 = Twofish.Fe32(nArray, n6, 0);
            n10 = Twofish.Fe32(nArray, n7, 3);
            n5 ^= n9 + 2 * n10 + nArray2[n8--];
            n5 = n5 >>> 1 | n5 << 31;
            n4 = n4 << 1 | n4 >>> 31;
            n4 ^= n9 + n10 + nArray2[n8--];
        }
        n7 ^= nArray2[1];
        n4 ^= nArray2[2];
        n5 ^= nArray2[3];
        byArray2[n2++] = (byte)(n6 ^= nArray2[0]);
        byArray2[n2++] = (byte)(n6 >>> 8);
        byArray2[n2++] = (byte)(n6 >>> 16);
        byArray2[n2++] = (byte)(n6 >>> 24);
        byArray2[n2++] = (byte)n7;
        byArray2[n2++] = (byte)(n7 >>> 8);
        byArray2[n2++] = (byte)(n7 >>> 16);
        byArray2[n2++] = (byte)(n7 >>> 24);
        byArray2[n2++] = (byte)n4;
        byArray2[n2++] = (byte)(n4 >>> 8);
        byArray2[n2++] = (byte)(n4 >>> 16);
        byArray2[n2++] = (byte)(n4 >>> 24);
        byArray2[n2++] = (byte)n5;
        byArray2[n2++] = (byte)(n5 >>> 8);
        byArray2[n2++] = (byte)(n5 >>> 16);
        byArray2[n2] = (byte)(n5 >>> 24);
    }

    public boolean selfTest() {
        if (valid == null) {
            boolean bl = super.selfTest();
            if (bl) {
                bl = this.testKat(KAT_KEY, KAT_CT);
            }
            valid = bl;
        }
        return valid;
    }

    static {
        int n;
        log = null;
        Pm = new String[]{"\ua967\ub3e8\u04fd\ua376\u9a92\u8078\ue4dd\ud138\u0dc6\u3598\u18f7\uec6c\u4375\u3726\ufa13\u9448\uf2d0\u8b30\u8454\udf23\u195b\u3d59\uf3ae\ua282\u6301\u832e\ud951\u9b7c\ua6eb\ua5be\u160c\ue361\uc08c\u3af5\u732c\u250b\ubb4e\u896b\u536a\ub4f1\ue1e6\ubd45\ue2f4\ub666\ucc95\u0356\ud41c\u1ed7\ufbc3\u8eb5\ue9cf\ubfba\uea77\u39af\u33c9\u6271\u8179\u09ad\u24cd\uf9d8\ue5c5\ub94d\u4408\u86e7\ua11d\uaaed\u0670\ub2d2\u417b\ua011\u31c2\u2790\u20f6\u60ff\u965c\ub1ab\u9e9c\u521b\u5f93\u0aef\u9185\u49ee\u2d4f\u8f3b\u4787\u6d46\ud63e\u6964\u2ace\ucb2f\ufc97\u057a\uac7f\ud51a\u4b0e\ua75a\u2814\u3f29\u883c\u4c02\ub8da\ub017\u551f\u8a7d\u57c7\u8d74\ub7c4\u9f72\u7e15\u2212\u5807\u9934\u6e50\ude68\u65bc\udbf8\uc8a8\u2b40\udcfe\u32a4\uca10\u21f0\ud35d\u0f00\u6f9d\u3642\u4a5e\uc1e0", "\u75f3\uc6f4\udb7b\ufbc8\u4ad3\ue66b\u457d\ue84b\ud632\ud8fd\u3771\uf1e1\u300f\uf81b\u87fa\u063f\u5eba\uae5b\u8a00\ubc9d\u6dc1\ub10e\u805d\ud2d5\ua084\u0714\ub590\u2ca3\ub273\u4c54\u9274\u3651\u38b0\ubd5a\ufc60\u6296\u6c42\uf710\u7c28\u278c\u1395\u9cc7\u2446\u3b70\ucae3\u85cb\u11d0\u93b8\ua683\u20ff\u9f77\uc3cc\u036f\u08bf\u40e7\u2be2\u790c\uaa82\u413a\ueab9\ue49a\ua497\u7eda\u7a17\u6694\ua11d\u3df0\udeb3\u0b72\ua71c\uefd1\u533e\u8f33\u265f\uec76\u2a49\u8188\uee21\uc41a\uebd9\uc539\u99cd\uad31\u8b01\u1823\udd1f\u4e2d\uf948\u4ff2\u658e\u785c\u5819\u8de5\u9857\u677f\u0564\uaf63\ub6fe\uf5b7\u3ca5\ucee9\u6844\ue04d\u4369\u292e\uac15\u59a8\u0a9e\u6e47\udf34\u356a\ucfdc\u22c9\uc09b\u89d4\uedab\u12a2\u0d52\ubb02\u2fa9\ud761\u1eb4\u5004\uf6c2\u1625\u8656\u5509\ube91"};
        P = new byte[2][256];
        MDS = new int[4][256];
        KAT_KEY = Util.toBytesFromString("0000000000000000000000000000000000000000000002000000000000000000");
        KAT_CT = Util.toBytesFromString("F51410475B33FBD3DB2117B5C17C82D4");
        long l = System.currentTimeMillis();
        for (n = 0; n < 256; ++n) {
            int n2 = Pm[0].charAt(n >>> 1);
            Twofish.P[0][n] = (byte)((n & 1) == 0 ? n2 >>> 8 : n2);
            n2 = Pm[1].charAt(n >>> 1);
            Twofish.P[1][n] = (byte)((n & 1) == 0 ? n2 >>> 8 : n2);
        }
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        int[] nArray3 = new int[2];
        for (n = 0; n < 256; ++n) {
            int n3;
            nArray[0] = n3 = P[0][n] & 0xFF;
            nArray2[0] = Twofish.Mx_X(n3) & 0xFF;
            nArray3[0] = Twofish.Mx_Y(n3) & 0xFF;
            nArray[1] = n3 = P[1][n] & 0xFF;
            nArray2[1] = Twofish.Mx_X(n3) & 0xFF;
            nArray3[1] = Twofish.Mx_Y(n3) & 0xFF;
            Twofish.MDS[0][n] = nArray[1] << 0 | nArray2[1] << 8 | nArray3[1] << 16 | nArray3[1] << 24;
            Twofish.MDS[1][n] = nArray3[0] << 0 | nArray3[0] << 8 | nArray2[0] << 16 | nArray[0] << 24;
            Twofish.MDS[2][n] = nArray2[1] << 0 | nArray3[1] << 8 | nArray[1] << 16 | nArray3[1] << 24;
            Twofish.MDS[3][n] = nArray2[0] << 0 | nArray[0] << 8 | nArray3[0] << 16 | nArray2[0] << 24;
        }
        l = System.currentTimeMillis() - l;
    }
}

