/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.cipher;

import gnu.java.lang.CPStringBuilder;
import gnu.javax.crypto.cipher.IBlockCipher;
import gnu.javax.crypto.cipher.IBlockCipherSpi;
import java.security.InvalidKeyException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

public abstract class BaseCipher
implements IBlockCipher,
IBlockCipherSpi {
    private static final Logger log = null;
    protected String name;
    protected int defaultBlockSize;
    protected int defaultKeySize;
    protected int currentBlockSize;
    protected transient Object currentKey;
    protected Object lock = new Object();

    protected BaseCipher(String string, int n, int n2) {
        this.name = string;
        this.defaultBlockSize = n;
        this.defaultKeySize = n2;
    }

    public abstract Object clone();

    public String name() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder(this.name).append('-');
        if (this.currentKey == null) {
            cPStringBuilder.append(String.valueOf(8 * this.defaultBlockSize));
        } else {
            cPStringBuilder.append(String.valueOf(8 * this.currentBlockSize));
        }
        return cPStringBuilder.toString();
    }

    public int defaultBlockSize() {
        return this.defaultBlockSize;
    }

    public int defaultKeySize() {
        return this.defaultKeySize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Map map) throws InvalidKeyException {
        Object object = this.lock;
        synchronized (object) {
            Object object2;
            if (this.currentKey != null) {
                throw new IllegalStateException();
            }
            Integer n = (Integer)map.get("gnu.crypto.cipher.block.size");
            if (n == null) {
                if (this.currentBlockSize == 0) {
                    this.currentBlockSize = this.defaultBlockSize;
                }
            } else {
                this.currentBlockSize = n;
                boolean bl = false;
                object2 = this.blockSizes();
                while (object2.hasNext() && !(bl = this.currentBlockSize == (Integer)object2.next())) {
                }
                if (!bl) {
                    throw new IllegalArgumentException("gnu.crypto.cipher.block.size");
                }
            }
            object2 = (byte[])map.get("gnu.crypto.cipher.key.material");
            this.currentKey = this.makeKey((byte[])object2, this.currentBlockSize);
        }
    }

    public int currentBlockSize() {
        if (this.currentKey == null) {
            throw new IllegalStateException();
        }
        return this.currentBlockSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.currentKey = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws IllegalStateException {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentKey == null) {
                throw new IllegalStateException();
            }
            this.encrypt(byArray, n, byArray2, n2, this.currentKey, this.currentBlockSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws IllegalStateException {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentKey == null) {
                throw new IllegalStateException();
            }
            this.decrypt(byArray, n, byArray2, n2, this.currentKey, this.currentBlockSize);
        }
    }

    public boolean selfTest() {
        Iterator iterator = this.keySizes();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            Iterator iterator2 = this.blockSizes();
            while (iterator2.hasNext()) {
                if (this.testSymmetry(n, (Integer)iterator2.next())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean testSymmetry(int n, int n2) {
        try {
            int n3;
            byte[] byArray = new byte[n];
            byte[] byArray2 = new byte[n2];
            byte[] byArray3 = new byte[n2];
            byte[] byArray4 = new byte[n2];
            for (n3 = 0; n3 < n; ++n3) {
                byArray[n3] = (byte)n3;
            }
            for (n3 = 0; n3 < n2; ++n3) {
                byArray2[n3] = (byte)n3;
            }
            Object object = this.makeKey(byArray, n2);
            this.encrypt(byArray2, 0, byArray3, 0, object, n2);
            this.decrypt(byArray3, 0, byArray4, 0, object, n2);
            return Arrays.equals(byArray2, byArray4);
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean testKat(byte[] byArray, byte[] byArray2) {
        return this.testKat(byArray, byArray2, new byte[byArray2.length]);
    }

    protected boolean testKat(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        try {
            int n = byArray3.length;
            byte[] byArray4 = new byte[n];
            Object object = this.makeKey(byArray, n);
            this.encrypt(byArray3, 0, byArray4, 0, object, n);
            if (!Arrays.equals(byArray4, byArray2)) {
                return false;
            }
            this.decrypt(byArray4, 0, byArray4, 0, object, n);
            return Arrays.equals(byArray4, byArray3);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

