/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.assembly;

import gnu.javax.crypto.assembly.Cascade;
import gnu.javax.crypto.assembly.CascadeTransformer;
import gnu.javax.crypto.assembly.DeflateTransformer;
import gnu.javax.crypto.assembly.Direction;
import gnu.javax.crypto.assembly.Operation;
import gnu.javax.crypto.assembly.PaddingTransformer;
import gnu.javax.crypto.assembly.TransformerException;
import gnu.javax.crypto.pad.IPad;
import java.io.ByteArrayOutputStream;
import java.util.Map;

public abstract class Transformer {
    public static final String DIRECTION = "gnu.crypto.assembly.transformer.direction";
    protected Direction wired = null;
    protected Operation mode;
    protected Transformer tail = null;
    protected ByteArrayOutputStream inBuffer = new ByteArrayOutputStream(2048);
    protected ByteArrayOutputStream outBuffer = new ByteArrayOutputStream(2048);

    protected Transformer() {
    }

    public static final Transformer getCascadeTransformer(Cascade cascade) {
        return new CascadeTransformer(cascade);
    }

    public static final Transformer getPaddingTransformer(IPad iPad) {
        return new PaddingTransformer(iPad);
    }

    public static final Transformer getDeflateTransformer() {
        return new DeflateTransformer();
    }

    public void setMode(Operation operation) {
        if (this.mode != null) {
            throw new IllegalStateException();
        }
        this.mode = operation;
    }

    public boolean isPreProcessing() {
        if (this.mode == null) {
            throw new IllegalStateException();
        }
        return this.mode == Operation.PRE_PROCESSING;
    }

    public boolean isPostProcessing() {
        return !this.isPreProcessing();
    }

    public void init(Map map) throws TransformerException {
        if (this.wired != null) {
            throw new IllegalStateException();
        }
        Direction direction = (Direction)map.get(DIRECTION);
        if (direction == null) {
            direction = Direction.FORWARD;
        }
        this.wired = direction;
        this.inBuffer.reset();
        this.outBuffer.reset();
        this.tail.init(map);
        this.initDelegate(map);
    }

    public int currentBlockSize() {
        if (this.wired == null) {
            throw new IllegalStateException();
        }
        return this.delegateBlockSize();
    }

    public void reset() {
        this.resetDelegate();
        this.wired = null;
        this.inBuffer.reset();
        this.outBuffer.reset();
        this.tail.reset();
    }

    public byte[] update(byte by) throws TransformerException {
        return this.update(new byte[]{by}, 0, 1);
    }

    public byte[] update(byte[] byArray) throws TransformerException {
        return this.update(byArray, 0, byArray.length);
    }

    public byte[] update(byte[] byArray, int n, int n2) throws TransformerException {
        if (this.wired == null) {
            throw new IllegalStateException();
        }
        byte[] byArray2 = this.wired == Direction.FORWARD ? this.forwardUpdate(byArray, n, n2) : this.inverseUpdate(byArray, n, n2);
        return byArray2;
    }

    public byte[] lastUpdate() throws TransformerException {
        byte[] byArray;
        byte[] byArray2 = byArray = this.wired == Direction.FORWARD ? this.lastForwardUpdate() : this.lastInverseUpdate();
        if (this.inBuffer.size() != 0) {
            throw new TransformerException("lastUpdate(): input buffer not empty");
        }
        return byArray;
    }

    public byte[] lastUpdate(byte by) throws TransformerException {
        return this.lastUpdate(new byte[]{by}, 0, 1);
    }

    public byte[] lastUpdate(byte[] byArray) throws TransformerException {
        return this.lastUpdate(byArray, 0, byArray.length);
    }

    public byte[] lastUpdate(byte[] byArray, int n, int n2) throws TransformerException {
        byte[] byArray2 = this.update(byArray, n, n2);
        byte[] byArray3 = this.lastUpdate();
        if (byArray3.length > 0) {
            byte[] byArray4 = new byte[byArray2.length + byArray3.length];
            System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
            System.arraycopy(byArray3, 0, byArray4, byArray2.length, byArray3.length);
            byArray2 = byArray4;
        }
        return byArray2;
    }

    private byte[] forwardUpdate(byte[] byArray, int n, int n2) throws TransformerException {
        return this.isPreProcessing() ? this.preTransform(byArray, n, n2) : this.postTransform(byArray, n, n2);
    }

    private byte[] inverseUpdate(byte[] byArray, int n, int n2) throws TransformerException {
        return this.isPreProcessing() ? this.postTransform(byArray, n, n2) : this.preTransform(byArray, n, n2);
    }

    private byte[] preTransform(byte[] byArray, int n, int n2) throws TransformerException {
        byte[] byArray2 = this.updateDelegate(byArray, n, n2);
        byArray2 = this.tail.update(byArray2);
        return byArray2;
    }

    private byte[] postTransform(byte[] byArray, int n, int n2) throws TransformerException {
        byte[] byArray2 = this.tail.update(byArray, n, n2);
        byArray2 = this.updateDelegate(byArray2, 0, byArray2.length);
        return byArray2;
    }

    private byte[] lastForwardUpdate() throws TransformerException {
        return this.isPreProcessing() ? this.preLastTransform() : this.postLastTransform();
    }

    private byte[] lastInverseUpdate() throws TransformerException {
        return this.isPreProcessing() ? this.postLastTransform() : this.preLastTransform();
    }

    private byte[] preLastTransform() throws TransformerException {
        byte[] byArray = this.lastUpdateDelegate();
        byArray = this.tail.lastUpdate(byArray);
        return byArray;
    }

    private byte[] postLastTransform() throws TransformerException {
        byte[] byArray = this.tail.lastUpdate();
        byArray = this.updateDelegate(byArray, 0, byArray.length);
        byte[] byArray2 = this.lastUpdateDelegate();
        if (byArray2.length > 0) {
            byte[] byArray3 = new byte[byArray.length + byArray2.length];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
            byArray = byArray3;
        }
        return byArray;
    }

    abstract void initDelegate(Map var1) throws TransformerException;

    abstract int delegateBlockSize();

    abstract void resetDelegate();

    abstract byte[] updateDelegate(byte[] var1, int var2, int var3) throws TransformerException;

    abstract byte[] lastUpdateDelegate() throws TransformerException;
}

