/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.assembly;

import gnu.javax.crypto.assembly.Direction;
import gnu.javax.crypto.assembly.Stage;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class Cascade {
    public static final String DIRECTION = "gnu.crypto.assembly.cascade.direction";
    protected HashMap stages = new HashMap(3);
    protected LinkedList stageKeys = new LinkedList();
    protected Direction wired = null;
    protected int blockSize = 0;

    private static final int lcm(int n, int n2) {
        BigInteger bigInteger = BigInteger.valueOf((long)n * 1L);
        BigInteger bigInteger2 = BigInteger.valueOf((long)n2 * 1L);
        return bigInteger.multiply(bigInteger2).divide(bigInteger.gcd(bigInteger2)).abs().intValue();
    }

    public Object append(Stage stage) throws IllegalArgumentException {
        return this.insert(this.size(), stage);
    }

    public Object prepend(Stage stage) throws IllegalArgumentException {
        return this.insert(0, stage);
    }

    public Object insert(int n, Stage stage) throws IllegalArgumentException, IndexOutOfBoundsException {
        Object object;
        if (this.stages.containsValue(stage)) {
            throw new IllegalArgumentException();
        }
        if (this.wired != null || stage == null) {
            throw new IllegalStateException();
        }
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        Set set = stage.blockSizes();
        if (this.stages.isEmpty()) {
            if (set.isEmpty()) {
                throw new IllegalArgumentException("1st stage with no block sizes");
            }
        } else {
            object = this.blockSizes();
            object.retainAll(set);
            if (object.isEmpty()) {
                throw new IllegalArgumentException("no common block sizes found");
            }
        }
        object = new Object();
        this.stageKeys.add(n, object);
        this.stages.put(object, stage);
        return object;
    }

    public int size() {
        return this.stages.size();
    }

    public Iterator stages() {
        LinkedList linkedList = new LinkedList();
        ListIterator listIterator = this.stageKeys.listIterator();
        while (listIterator.hasNext()) {
            linkedList.addLast(this.stages.get(listIterator.next()));
        }
        return linkedList.listIterator();
    }

    public Set blockSizes() {
        HashSet hashSet = null;
        for (Stage stage : this.stages.values()) {
            if (hashSet == null) {
                hashSet = new HashSet(stage.blockSizes());
                continue;
            }
            hashSet.retainAll(stage.blockSizes());
        }
        return hashSet == null ? Collections.EMPTY_SET : hashSet;
    }

    public void init(Map map) throws InvalidKeyException {
        if (this.wired != null) {
            throw new IllegalStateException();
        }
        Direction direction = (Direction)map.get(DIRECTION);
        if (direction == null) {
            direction = Direction.FORWARD;
        }
        int n = 0;
        ListIterator listIterator = this.stageKeys.listIterator();
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            Map map2 = (Map)map.get(e);
            map2.put("gnu.crypto.assembly.stage.direction", direction);
            Stage stage = (Stage)this.stages.get(e);
            stage.init(map2);
            n = n == 0 ? stage.currentBlockSize() : Cascade.lcm(n, stage.currentBlockSize());
        }
        if (direction == Direction.REVERSED) {
            Collections.reverse(this.stageKeys);
        }
        this.wired = direction;
        this.blockSize = n;
    }

    public int currentBlockSize() {
        if (this.wired == null) {
            throw new IllegalStateException();
        }
        return this.blockSize;
    }

    public void reset() {
        ListIterator listIterator = this.stageKeys.listIterator();
        while (listIterator.hasNext()) {
            ((Stage)this.stages.get(listIterator.next())).reset();
        }
        if (this.wired == Direction.REVERSED) {
            Collections.reverse(this.stageKeys);
        }
        this.wired = null;
        this.blockSize = 0;
    }

    public void update(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (this.wired == null) {
            throw new IllegalStateException();
        }
        int n3 = this.stages.size();
        ListIterator listIterator = this.stageKeys.listIterator();
        while (listIterator.hasNext()) {
            Stage stage = (Stage)this.stages.get(listIterator.next());
            int n4 = stage.currentBlockSize();
            for (int i = 0; i < this.blockSize; i += n4) {
                stage.update(byArray, n + i, byArray2, n2 + i);
            }
            if (--n3 <= 0) continue;
            System.arraycopy(byArray2, n2, byArray, n, this.blockSize);
        }
    }

    public boolean selfTest() {
        ListIterator listIterator = this.stageKeys.listIterator();
        while (listIterator.hasNext()) {
            if (((Stage)this.stages.get(listIterator.next())).selfTest()) continue;
            return false;
        }
        return true;
    }
}

