/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util.regex;

import gnu.java.lang.CPStringBuilder;
import gnu.java.util.regex.BacktrackStack;
import gnu.java.util.regex.CharIndexed;
import gnu.java.util.regex.REMatch;
import gnu.java.util.regex.REToken;
import java.util.ArrayDeque;
import java.util.Deque;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RETokenRepeated
extends REToken {
    private REToken token;
    private int min;
    private int max;
    private boolean stingy;
    private boolean possessive;
    private int tokenFixedLength;

    RETokenRepeated(int n, REToken rEToken, int n2, int n3) {
        super(n);
        this.token = rEToken;
        this.min = n2;
        this.max = n3;
        this.tokenFixedLength = rEToken.returnsFixedLengthMatches() ? rEToken.getMaximumLength() : -1;
    }

    void makeStingy() {
        this.stingy = true;
    }

    boolean isStingy() {
        return this.stingy;
    }

    void makePossessive() {
        this.possessive = true;
    }

    boolean isPossessive() {
        return this.possessive;
    }

    @Override
    int getMinimumLength() {
        return this.min * this.token.getMinimumLength();
    }

    @Override
    int getMaximumLength() {
        if (this.max == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        int n = this.token.getMaximumLength();
        if (n == Integer.MAX_VALUE) {
            return n;
        }
        return this.max * n;
    }

    @Override
    REMatch findMatch(CharIndexed charIndexed, REMatch rEMatch) {
        if (this.tokenFixedLength >= 0) {
            return this.findMatchFixedLength(charIndexed, rEMatch);
        }
        BacktrackStack backtrackStack = new BacktrackStack();
        backtrackStack.push(new StackedInfo(charIndexed, 0, rEMatch, null, null));
        return this.findMatch(backtrackStack);
    }

    @Override
    REMatch backtrack(CharIndexed charIndexed, REMatch rEMatch, Object object) {
        if (this.tokenFixedLength >= 0) {
            return this.backtrackFixedLength(charIndexed, rEMatch, object);
        }
        return this.findMatch((BacktrackStack)object);
    }

    private REMatch findMatch(BacktrackStack backtrackStack) {
        return this.findMatch(backtrackStack, new ArrayDeque<FindMatchControl>());
    }

    private REMatch findMatch(BacktrackStack backtrackStack, Deque<FindMatchControl> deque) {
        Object object = null;
        StackedInfo stackedInfo = null;
        CharIndexed charIndexed = null;
        int n = 0;
        REMatch rEMatch = null;
        int[] nArray = null;
        DoablesFinder doablesFinder = null;
        block8: while (true) {
            Object object2;
            if (!backtrackStack.empty()) {
                stackedInfo = (StackedInfo)backtrackStack.peek();
                charIndexed = stackedInfo.input;
                n = stackedInfo.numRepeats;
                rEMatch = stackedInfo.match;
                nArray = stackedInfo.visited;
                doablesFinder = stackedInfo.finder;
                if (rEMatch.backtrackStack == null) {
                    rEMatch.backtrackStack = new BacktrackStack();
                }
                if (n >= this.max) {
                    backtrackStack.pop();
                    object2 = this.matchRest(charIndexed, rEMatch);
                    if (object2 != null) {
                        if (!backtrackStack.empty()) {
                            ((REMatch)object2).backtrackStack.push(new BacktrackStack.Backtrack(this, charIndexed, rEMatch, backtrackStack));
                        }
                        object = object2;
                    } else if (this.stingy) {
                        continue;
                    }
                } else {
                    if (doablesFinder == null) {
                        stackedInfo.finder = doablesFinder = new DoablesFinder(this.token, charIndexed, rEMatch);
                    }
                    if (n < this.min) {
                        object2 = doablesFinder.find();
                        if (object2 == null) {
                            if (backtrackStack.empty()) {
                                return null;
                            }
                            backtrackStack.pop();
                            continue;
                        }
                        if (doablesFinder.noMore()) {
                            backtrackStack.pop();
                        }
                        int n2 = ((REMatch)object2).empty ? this.min : n + 1;
                        backtrackStack.push(new StackedInfo(charIndexed, n2, (REMatch)object2, nArray, null));
                        continue;
                    }
                    if (nArray == null) {
                        nArray = RETokenRepeated.initVisited();
                    }
                    if (this.stingy) {
                        REMatch rEMatch2;
                        object2 = doablesFinder.find();
                        if (object2 != null && !((REMatch)object2).empty) {
                            backtrackStack.push(new StackedInfo(charIndexed, n + 1, (REMatch)object2, nArray, null));
                        } else {
                            backtrackStack.pop();
                        }
                        if ((rEMatch2 = this.matchRest(charIndexed, rEMatch)) == null) continue;
                        if (!backtrackStack.empty()) {
                            rEMatch2.backtrackStack.push(new BacktrackStack.Backtrack(this, charIndexed, rEMatch, backtrackStack));
                        }
                        object = rEMatch2;
                    } else {
                        nArray = RETokenRepeated.addVisited(rEMatch.index, nArray);
                        object2 = this.tryAnother(backtrackStack, charIndexed, rEMatch, n, doablesFinder, nArray);
                        nArray = ((TryAnotherResult)object2).visited;
                        switch (((TryAnotherResult)object2).status) {
                            case 2: {
                                deque.push(new FindMatchControl(doablesFinder));
                                continue block8;
                            }
                            case 1: {
                                object = ((TryAnotherResult)object2).result;
                                break;
                            }
                            default: {
                                REMatch rEMatch3;
                                if (!backtrackStack.empty()) {
                                    backtrackStack.pop();
                                }
                                if (this.possessive) {
                                    backtrackStack.clear();
                                }
                                if ((rEMatch3 = this.matchRest(charIndexed, rEMatch)) == null) continue block8;
                                if (!backtrackStack.empty()) {
                                    rEMatch3.backtrackStack.push(new BacktrackStack.Backtrack(this, charIndexed, rEMatch, backtrackStack));
                                }
                                object = rEMatch3;
                                break;
                            }
                        }
                    }
                }
            }
            if (deque.isEmpty()) {
                return object;
            }
            object2 = deque.pop();
            if (this.possessive) {
                return object;
            }
            if (object != null) {
                ((REMatch)object).backtrackStack.push(new BacktrackStack.Backtrack(this, charIndexed, rEMatch, backtrackStack));
                return object;
            }
            doablesFinder = ((FindMatchControl)object2).finder;
            TryAnotherResult tryAnotherResult = this.tryAnother(backtrackStack, charIndexed, rEMatch, n, doablesFinder, nArray);
            nArray = tryAnotherResult.visited;
            switch (tryAnotherResult.status) {
                case 2: {
                    deque.push(new FindMatchControl(doablesFinder));
                    continue block8;
                }
                case 1: {
                    return tryAnotherResult.result;
                }
            }
        }
    }

    private TryAnotherResult tryAnother(BacktrackStack backtrackStack, CharIndexed charIndexed, REMatch rEMatch, int n, DoablesFinder doablesFinder, int[] nArray) {
        REMatch rEMatch2;
        TryAnotherResult tryAnotherResult = new TryAnotherResult();
        tryAnotherResult.visited = nArray;
        boolean bl = false;
        while ((rEMatch2 = doablesFinder.find()) != null) {
            if (rEMatch2.empty) {
                bl = true;
            }
            if (!bl) {
                int n2 = rEMatch2.index;
                if (RETokenRepeated.visitedContains(n2, nArray)) continue;
                nArray = RETokenRepeated.addVisited(n2, nArray);
                backtrackStack.push(new StackedInfo(charIndexed, n + 1, rEMatch2, nArray, null));
                tryAnotherResult.visited = nArray;
                tryAnotherResult.status = 2;
                return tryAnotherResult;
            }
            REMatch rEMatch3 = this.matchRest(charIndexed, rEMatch2);
            if (this.possessive) {
                tryAnotherResult.result = rEMatch3;
                tryAnotherResult.status = 1;
                return tryAnotherResult;
            }
            if (rEMatch3 == null) continue;
            if (!backtrackStack.empty()) {
                rEMatch3.backtrackStack.push(new BacktrackStack.Backtrack(this, charIndexed, rEMatch, backtrackStack));
            }
            tryAnotherResult.result = rEMatch3;
            tryAnotherResult.status = 1;
            return tryAnotherResult;
        }
        tryAnotherResult.status = 3;
        return tryAnotherResult;
    }

    @Override
    boolean match(CharIndexed charIndexed, REMatch rEMatch) {
        this.setHitEnd(charIndexed, rEMatch);
        REMatch rEMatch2 = this.findMatch(charIndexed, rEMatch);
        if (rEMatch2 != null) {
            rEMatch.assignFrom(rEMatch2);
            return true;
        }
        return false;
    }

    private static int[] initVisited() {
        int[] nArray = new int[32];
        nArray[0] = 0;
        return nArray;
    }

    private static boolean visitedContains(int n, int[] nArray) {
        for (int i = 1; i < nArray[0]; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }

    private static int[] addVisited(int n, int[] nArray) {
        if (RETokenRepeated.visitedContains(n, nArray)) {
            return nArray;
        }
        if (nArray[0] >= nArray.length - 1) {
            int[] nArray2 = new int[nArray.length + 32];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            nArray = nArray2;
        }
        nArray[0] = nArray[0] + 1;
        nArray[nArray[0]] = n;
        return nArray;
    }

    private REMatch matchRest(CharIndexed charIndexed, REMatch rEMatch) {
        if (this.next(charIndexed, rEMatch)) {
            return rEMatch;
        }
        return null;
    }

    private REMatch findMatchFixedLength(CharIndexed charIndexed, REMatch rEMatch) {
        int n;
        int n2;
        if (rEMatch.backtrackStack == null) {
            rEMatch.backtrackStack = new BacktrackStack();
        }
        if ((n2 = this.token.findFixedLengthMatches(charIndexed, (REMatch)rEMatch.clone(), this.max)) == Integer.MAX_VALUE) {
            n2 = this.min;
        }
        if ((n = n2 - this.min + 1) <= 0) {
            return null;
        }
        int n3 = 0;
        n3 = !this.stingy ? rEMatch.index + this.tokenFixedLength * n2 : rEMatch.index + this.tokenFixedLength * this.min;
        return this.findMatchFixedLength(charIndexed, rEMatch, n3, n);
    }

    private REMatch backtrackFixedLength(CharIndexed charIndexed, REMatch rEMatch, Object object) {
        int[] nArray = (int[])object;
        int n = nArray[0];
        int n2 = nArray[1];
        return this.findMatchFixedLength(charIndexed, rEMatch, n, n2);
    }

    private REMatch findMatchFixedLength(CharIndexed charIndexed, REMatch rEMatch, int n, int n2) {
        REMatch rEMatch2 = (REMatch)rEMatch.clone();
        do {
            rEMatch2.index = n;
            REMatch rEMatch3 = this.matchRest(charIndexed, rEMatch2);
            --n2;
            n = this.stingy ? (n += this.tokenFixedLength) : (n -= this.tokenFixedLength);
            if (this.possessive) {
                return rEMatch3;
            }
            if (rEMatch3 == null) continue;
            if (n2 > 0) {
                rEMatch3.backtrackStack.push(new BacktrackStack.Backtrack(this, charIndexed, rEMatch, new int[]{n, n2}));
            }
            return rEMatch3;
        } while (n2 > 0);
        return null;
    }

    @Override
    void dump(CPStringBuilder cPStringBuilder) {
        cPStringBuilder.append("(?:");
        this.token.dumpAll(cPStringBuilder);
        cPStringBuilder.append(')');
        if (this.max == Integer.MAX_VALUE && this.min <= 1) {
            cPStringBuilder.append(this.min == 0 ? (char)'*' : '+');
        } else if (this.min == 0 && this.max == 1) {
            cPStringBuilder.append('?');
        } else {
            cPStringBuilder.append('{').append(this.min);
            if (this.max > this.min) {
                cPStringBuilder.append(',');
                if (this.max != Integer.MAX_VALUE) {
                    cPStringBuilder.append(this.max);
                }
            }
            cPStringBuilder.append('}');
        }
        if (this.stingy) {
            cPStringBuilder.append('?');
        }
    }

    private static class TryAnotherResult {
        REMatch result;
        int status;
        static final int RESULT_FOUND = 1;
        static final int TRY_FURTHER = 2;
        static final int NOTHING_FOUND = 3;
        int[] visited;

        private TryAnotherResult() {
        }
    }

    private static class FindMatchControl {
        DoablesFinder finder;

        FindMatchControl(DoablesFinder doablesFinder) {
            this.finder = doablesFinder;
        }
    }

    private static class StackedInfo
    extends BacktrackStack.Backtrack {
        int numRepeats;
        int[] visited;
        DoablesFinder finder;

        StackedInfo(CharIndexed charIndexed, int n, REMatch rEMatch, int[] nArray, DoablesFinder doablesFinder) {
            super(null, charIndexed, rEMatch, null);
            this.numRepeats = n;
            this.visited = nArray;
            this.finder = doablesFinder;
        }
    }

    private static class DoablesFinder {
        private REToken tk;
        private CharIndexed input;
        private REMatch rematch;
        private boolean findFirst;

        private DoablesFinder(REToken rEToken, CharIndexed charIndexed, REMatch rEMatch) {
            this.tk = rEToken;
            this.input = charIndexed;
            this.rematch = (REMatch)rEMatch.clone();
            this.rematch.backtrackStack = new BacktrackStack();
            this.findFirst = true;
        }

        private REMatch find() {
            REMatch rEMatch;
            int n = this.rematch.index;
            if (this.findFirst) {
                rEMatch = this.tk.findMatch(this.input, this.rematch);
                this.findFirst = false;
            } else {
                BacktrackStack.Backtrack backtrack;
                do {
                    if (this.rematch.backtrackStack.empty()) {
                        rEMatch = null;
                        break;
                    }
                    backtrack = this.rematch.backtrackStack.pop();
                } while ((rEMatch = backtrack.token.backtrack(backtrack.input, backtrack.match, backtrack.param)) == null);
            }
            if (rEMatch == null) {
                return null;
            }
            if (rEMatch.index == n) {
                rEMatch.empty = true;
            }
            this.rematch = rEMatch;
            return (REMatch)rEMatch.clone();
        }

        boolean noMore() {
            return this.rematch.backtrackStack.empty();
        }
    }
}

