/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util.regex;

import gnu.java.util.regex.CharIndexed;
import gnu.java.util.regex.REMatch;
import java.io.Serializable;

class CharIndexedCharSequence
implements CharIndexed,
Serializable {
    private CharSequence s;
    private int anchor;
    private int len;
    private REMatch lastMatch;
    private int rightmostTriedPosition = 0;

    CharIndexedCharSequence(CharSequence charSequence, int n) {
        this.s = charSequence;
        this.len = charSequence.length();
        this.anchor = n;
    }

    public char charAt(int n) {
        int n2 = this.anchor + n;
        return n2 < this.len && n2 >= 0 ? this.s.charAt(n2) : (char)'\uffff';
    }

    public boolean isValid() {
        return this.anchor < this.len;
    }

    public boolean move(int n) {
        return (this.anchor += n) < this.len;
    }

    public boolean move1(int n) {
        return (this.anchor += n) <= this.len;
    }

    public CharIndexed lookBehind(int n, int n2) {
        if (n2 > this.anchor + n) {
            n2 = this.anchor + n;
        }
        return new CharIndexedCharSequence(this.s, this.anchor + n - n2);
    }

    public int length() {
        return this.len - this.anchor;
    }

    public void setLastMatch(REMatch rEMatch) {
        this.lastMatch = (REMatch)rEMatch.clone();
        this.lastMatch.anchor = this.anchor;
    }

    public REMatch getLastMatch() {
        return this.lastMatch;
    }

    public void setHitEnd(REMatch rEMatch) {
        int n = this.anchor + rEMatch.index;
        if (n > this.rightmostTriedPosition) {
            this.rightmostTriedPosition = n;
        }
    }

    public boolean hitEnd() {
        return this.rightmostTriedPosition >= this.len;
    }

    public int getAnchor() {
        return this.anchor;
    }

    public void setAnchor(int n) {
        this.anchor = n;
    }
}

