/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util.prefs;

import gnu.java.lang.CPStringBuilder;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class NodeWriter {
    private final Preferences prefs;
    private final BufferedWriter bw;
    private boolean subtree;

    public NodeWriter(Preferences preferences, OutputStream outputStream) {
        OutputStreamWriter outputStreamWriter;
        this.prefs = preferences;
        try {
            outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            InternalError internalError = new InternalError("UTF-8 encoding missing");
            internalError.initCause(unsupportedEncodingException);
            throw internalError;
        }
        this.bw = new BufferedWriter(outputStreamWriter);
    }

    public void writePrefsTree() throws BackingStoreException, IOException {
        this.subtree = true;
        this.writeHeader();
        this.writePreferences();
        this.bw.flush();
    }

    public void writePrefs() throws BackingStoreException, IOException {
        this.subtree = false;
        this.writeHeader();
        this.writePreferences();
        this.bw.flush();
    }

    private void writeHeader() throws BackingStoreException, IOException {
        this.bw.write("<?xml version=\"1.0\"?>");
        this.bw.newLine();
        this.bw.write("<!DOCTYPE preferences SYSTEM \"http://java.sun.com/dtd/preferences.dtd\">");
        this.bw.newLine();
        this.bw.newLine();
        this.bw.write("<!-- GNU Classpath java.util.prefs Preferences ");
        if (this.prefs.isUserNode()) {
            this.bw.write("user");
        } else {
            this.bw.write("system");
        }
        if (this.prefs.parent() == null) {
            this.bw.write(" root");
        }
        if (this.subtree) {
            this.bw.write(" tree");
        } else {
            this.bw.write(" node");
        }
        if (this.prefs.parent() != null) {
            this.bw.newLine();
            this.bw.write("     '");
            this.bw.write(this.prefs.absolutePath());
            this.bw.write(39);
            this.bw.newLine();
        }
        this.bw.write(" -->");
        this.bw.newLine();
        this.bw.newLine();
    }

    private void writePreferences() throws BackingStoreException, IOException {
        this.bw.write("<preferences>");
        this.bw.newLine();
        this.writeRoot();
        this.bw.write("</preferences>");
        this.bw.newLine();
    }

    private void writeRoot() throws BackingStoreException, IOException {
        this.bw.write("  <root type=\"");
        if (this.prefs.isUserNode()) {
            this.bw.write("user");
        } else {
            this.bw.write("system");
        }
        this.bw.write("\">");
        this.writeRootMap();
        this.writeNode();
        this.bw.write("  </root>");
        this.bw.newLine();
    }

    private void writeRootMap() throws BackingStoreException, IOException {
        if (this.prefs.parent() == null && this.prefs.keys().length > 0) {
            this.bw.newLine();
            this.writeMap(this.prefs, 2);
        } else {
            this.bw.write("<map/>");
            this.bw.newLine();
        }
    }

    private int writeParents() throws IOException {
        int n;
        String string = this.prefs.absolutePath();
        int n2 = string.lastIndexOf("/");
        if (n2 > 0) {
            string = string.substring(1, n2);
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            n = stringTokenizer.countTokens();
            for (int i = 0; i < n; ++i) {
                String string2 = stringTokenizer.nextToken();
                this.indent(i + 2);
                this.bw.write("<node name=\"" + string2 + "\">");
                this.bw.write("<map/>");
                this.bw.write("</node>");
                this.bw.newLine();
            }
        } else {
            n = 0;
        }
        return n;
    }

    private void writeCloseParents(int n) throws IOException {
        while (n > 0) {
            this.indent(n + 1);
            this.bw.write("</node>");
            this.bw.newLine();
            --n;
        }
    }

    private void writeNode() throws BackingStoreException, IOException {
        int n = this.writeParents();
        int n2 = this.prefs.parent() == null ? n + 1 : n + 2;
        this.writeNode(this.prefs, n2);
        this.writeCloseParents(n);
    }

    private void writeNode(Preferences preferences, int n) throws BackingStoreException, IOException {
        if (preferences.parent() != null) {
            this.indent(n);
            this.bw.write("<node name=\"" + preferences.name() + "\">");
            if (preferences.keys().length > 0) {
                this.bw.newLine();
            }
            this.writeMap(preferences, n + 1);
        }
        if (this.subtree) {
            String[] stringArray = preferences.childrenNames();
            for (int i = 0; i < stringArray.length; ++i) {
                Preferences preferences2 = preferences.node(stringArray[i]);
                this.writeNode(preferences2, n + 1);
            }
        }
        if (preferences.parent() != null) {
            this.indent(n);
            this.bw.write("</node>");
            this.bw.newLine();
        }
    }

    private void writeMap(Preferences preferences, int n) throws BackingStoreException, IOException {
        CPStringBuilder cPStringBuilder = new CPStringBuilder(2 * n);
        for (int i = 0; i < n; ++i) {
            cPStringBuilder.append("  ");
        }
        String string = cPStringBuilder.toString();
        if (preferences.keys().length > 0) {
            this.bw.write(string);
            this.bw.write("<map>");
            this.bw.newLine();
            this.writeEntries(preferences, string + "  ");
            this.bw.write(string);
            this.bw.write("</map>");
        } else {
            this.bw.write("<map/>");
        }
        this.bw.newLine();
    }

    private void writeEntries(Preferences preferences, String string) throws BackingStoreException, IOException {
        String[] stringArray = preferences.keys();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = preferences.get(stringArray[i], null);
            if (string2 == null) {
                throw new BackingStoreException("null value for key '" + stringArray[i] + "'");
            }
            this.bw.write(string);
            this.bw.write("<entry key=\"" + stringArray[i] + "\"" + " value=\"" + string2 + "\"/>");
            this.bw.newLine();
        }
    }

    private void indent(int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.bw.write("  ");
        }
    }
}

