/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util.prefs;

import gnu.java.util.prefs.gconf.GConfNativePeer;
import java.security.Permission;
import java.util.List;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;

public class GConfBasedPreferences
extends AbstractPreferences {
    private static final Permission PERMISSION = new RuntimePermission("preferences");
    private static GConfNativePeer backend = new GConfNativePeer();
    private static final String DEFAULT_USER_ROOT = "/apps/classpath";
    private static final String DEFAULT_SYSTEM_ROOT = "/system";
    private String node = "";
    private final boolean isUser;

    public GConfBasedPreferences() {
        this(true);
    }

    public GConfBasedPreferences(boolean bl) {
        this(null, "", bl);
    }

    public GConfBasedPreferences(AbstractPreferences abstractPreferences, String string, boolean bl) {
        super(abstractPreferences, string);
        int n;
        this.isUser = bl;
        String string2 = this.absolutePath();
        if (string2 != null && string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if ((n = string2.lastIndexOf(47)) > -1) {
            string2 = string2.substring(0, n + 1);
            string2 = string2 + GConfNativePeer.escapeString(string);
        }
        this.node = this.getRealRoot(bl) + string2;
        boolean bl2 = backend.nodeExist(this.node);
        this.newNode = !bl2;
    }

    protected AbstractPreferences childSpi(String string) {
        GConfBasedPreferences gConfBasedPreferences = new GConfBasedPreferences(this, string, this.isUser);
        return gConfBasedPreferences;
    }

    protected String[] childrenNamesSpi() throws BackingStoreException {
        List<String> list2 = backend.getChildrenNodes(this.node);
        String[] stringArray = new String[list2.size()];
        list2.toArray(stringArray);
        return stringArray;
    }

    public void flush() throws BackingStoreException {
        backend.suggestSync();
    }

    protected void flushSpi() throws BackingStoreException {
        this.flush();
    }

    protected String[] keysSpi() throws BackingStoreException {
        List<String> list2 = backend.getKeys(this.node);
        String[] stringArray = new String[list2.size()];
        list2.toArray(stringArray);
        return stringArray;
    }

    private void postorderRemove(String string) {
        try {
            Object object;
            Object object2;
            List<String> list2 = backend.getChildrenNodes(string);
            if (list2.size() != 0) {
                object2 = list2.iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    this.postorderRemove((String)object);
                }
            }
            if ((object2 = backend.getKeys(string)).size() != 0) {
                object = object2.iterator();
                while (object.hasNext()) {
                    String string2 = (String)object.next();
                    this.removeSpi(string2);
                }
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    protected void putSpi(String string, String string2) {
        backend.setString(this.getGConfKey(string), string2);
    }

    protected void removeNodeSpi() throws BackingStoreException {
        this.postorderRemove(this.node);
        this.flush();
    }

    protected void removeSpi(String string) {
        backend.unset(this.getGConfKey(string));
    }

    public void sync() throws BackingStoreException {
        this.flush();
    }

    protected void syncSpi() throws BackingStoreException {
        this.sync();
    }

    protected String getSpi(String string) {
        return backend.getKey(this.getGConfKey(string));
    }

    public boolean isUserNode() {
        return this.isUser;
    }

    private String getGConfKey(String string) {
        String string2 = "";
        string = GConfNativePeer.escapeString(string);
        string2 = this.node.endsWith("/") ? this.node + string : this.node + "/" + string;
        return string2;
    }

    private String getRealRoot(boolean bl) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(PERMISSION);
        }
        String string = null;
        string = bl ? System.getProperty("gnu.java.util.prefs.gconf.user_root", DEFAULT_USER_ROOT) : System.getProperty("gnu.java.util.prefs.gconf.system_root", DEFAULT_SYSTEM_ROOT);
        return string;
    }
}

