/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util.jar;

import gnu.classpath.SystemProperties;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarException;
import java.util.logging.Logger;

public abstract class JarUtils {
    private static final Logger log = Logger.getLogger(JarUtils.class.getName());
    public static final String META_INF = "META-INF/";
    public static final String DSA_SUFFIX = ".DSA";
    public static final String SF_SUFFIX = ".SF";
    public static final String NAME = "Name";
    public static final String MANIFEST_VERSION = "Manifest-Version";
    public static final String SIGNATURE_VERSION = "Signature-Version";
    public static final byte[] CRLF = new byte[]{13, 10};
    private static final String DEFAULT_MF_VERSION = "1.0";
    private static final String DEFAULT_SF_VERSION = "1.0";
    private static final Attributes.Name CREATED_BY = new Attributes.Name("Created-By");
    private static final String CREATOR = SystemProperties.getProperty("java.version") + " (" + SystemProperties.getProperty("java.vendor") + ")";

    public static void readMFManifest(Attributes attributes, Map map, InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        JarUtils.readMainSection(attributes, bufferedReader);
        JarUtils.readIndividualSections(map, bufferedReader);
    }

    public static void readSFManifest(Attributes attributes, Map map, InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        String string2 = Attributes.Name.SIGNATURE_VERSION.toString();
        try {
            string = JarUtils.expectHeader(string2, bufferedReader);
            attributes.putValue(SIGNATURE_VERSION, string);
            if (!"1.0".equals(string)) {
                log.warning("Unexpected version number: " + string + ". Continue (but may fail later)");
            }
        }
        catch (IOException iOException) {
            throw new JarException("Signature file MUST start with a " + string2 + ": " + iOException.getMessage());
        }
        JarUtils.read_attributes(attributes, bufferedReader);
        string = bufferedReader.readLine();
        while (string != null && string.length() > 0) {
            Attributes attributes2 = JarUtils.readSectionName(string, bufferedReader, map);
            JarUtils.read_attributes(attributes2, bufferedReader);
            string = bufferedReader.readLine();
        }
    }

    private static void readMainSection(Attributes attributes, BufferedReader bufferedReader) throws IOException {
        JarUtils.read_attributes(attributes, bufferedReader);
        if (attributes.getValue(Attributes.Name.MANIFEST_VERSION) == null) {
            attributes.putValue(MANIFEST_VERSION, "0.0");
        }
    }

    private static void readIndividualSections(Map map, BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        while (string != null && !string.equals("")) {
            Attributes attributes = JarUtils.readSectionName(string, bufferedReader, map);
            JarUtils.read_attributes(attributes, bufferedReader);
            string = bufferedReader.readLine();
        }
    }

    private static void readVersionInfo(Attributes attributes, BufferedReader bufferedReader) throws IOException {
        String string = Attributes.Name.MANIFEST_VERSION.toString();
        try {
            String string2 = JarUtils.expectHeader(string, bufferedReader);
            attributes.putValue(MANIFEST_VERSION, string2);
        }
        catch (IOException iOException) {
            throw new JarException("Manifest should start with a " + string + ": " + iOException.getMessage());
        }
    }

    private static String expectHeader(String string, BufferedReader bufferedReader) throws IOException {
        String string2 = bufferedReader.readLine();
        if (string2 == null) {
            throw new JarException("unexpected end of file");
        }
        return JarUtils.expectHeader(string, bufferedReader, string2);
    }

    private static void read_attributes(Attributes attributes, BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        while (string != null && !string.equals("")) {
            JarUtils.readAttribute(attributes, string, bufferedReader);
            string = bufferedReader.readLine();
        }
    }

    private static void readAttribute(Attributes attributes, String string, BufferedReader bufferedReader) throws IOException {
        try {
            int n = string.indexOf(": ");
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 2);
            String string4 = JarUtils.readHeaderValue(string3, bufferedReader);
            attributes.putValue(string2, string4);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new JarException("Manifest contains a bad header: " + string);
        }
    }

    private static String readHeaderValue(String string, BufferedReader bufferedReader) throws IOException {
        boolean bl = true;
        while (bl) {
            bufferedReader.mark(1);
            if (bufferedReader.read() == 32) {
                string = string + bufferedReader.readLine();
                continue;
            }
            bufferedReader.reset();
            bl = false;
        }
        return string;
    }

    private static Attributes readSectionName(String string, BufferedReader bufferedReader, Map map) throws JarException {
        try {
            String string2 = JarUtils.expectHeader(NAME, bufferedReader, string);
            Attributes attributes = new Attributes();
            map.put(string2, attributes);
            return attributes;
        }
        catch (IOException iOException) {
            throw new JarException("Section should start with a Name header: " + iOException.getMessage());
        }
    }

    private static String expectHeader(String string, BufferedReader bufferedReader, String string2) throws IOException {
        try {
            String string3 = string2.substring(0, string.length() + 1);
            if (string3.equalsIgnoreCase(string + ":")) {
                String string4 = string2.substring(string.length() + 2);
                return JarUtils.readHeaderValue(string4, bufferedReader);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        throw new JarException("unexpected '" + string2 + "'");
    }

    public static void writeMFManifest(Attributes attributes, Map map, OutputStream outputStream) throws IOException {
        BufferedOutputStream bufferedOutputStream = outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream, 4096);
        JarUtils.writeVersionInfo(attributes, bufferedOutputStream);
        for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
            if (Attributes.Name.MANIFEST_VERSION.equals(entry.getKey())) continue;
            JarUtils.writeAttributeEntry(entry, bufferedOutputStream);
        }
        bufferedOutputStream.write(CRLF);
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            JarUtils.writeHeader(NAME, entry.getKey().toString(), bufferedOutputStream);
            Attributes attributes2 = (Attributes)entry.getValue();
            for (Map.Entry<Object, Object> entry2 : attributes2.entrySet()) {
                JarUtils.writeAttributeEntry(entry2, bufferedOutputStream);
            }
            bufferedOutputStream.write(CRLF);
        }
        bufferedOutputStream.flush();
    }

    public static void writeSFManifest(Attributes attributes, Map map, OutputStream outputStream) throws IOException {
        BufferedOutputStream bufferedOutputStream = outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream, 4096);
        JarUtils.writeHeader(Attributes.Name.SIGNATURE_VERSION.toString(), "1.0", bufferedOutputStream);
        JarUtils.writeHeader(CREATED_BY.toString(), CREATOR, bufferedOutputStream);
        for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
            Attributes.Name name = (Attributes.Name)entry.getKey();
            if (Attributes.Name.SIGNATURE_VERSION.equals(name) || CREATED_BY.equals(name)) continue;
            JarUtils.writeHeader(name.toString(), (String)entry.getValue(), bufferedOutputStream);
        }
        bufferedOutputStream.write(CRLF);
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            JarUtils.writeHeader(NAME, entry.getKey().toString(), bufferedOutputStream);
            Attributes attributes2 = (Attributes)entry.getValue();
            for (Map.Entry entry2 : attributes2.entrySet()) {
                JarUtils.writeHeader(entry2.getKey().toString(), (String)entry2.getValue(), bufferedOutputStream);
            }
            bufferedOutputStream.write(CRLF);
        }
        bufferedOutputStream.flush();
    }

    private static void writeVersionInfo(Attributes attributes, OutputStream outputStream) throws IOException {
        String string = attributes.getValue(Attributes.Name.MANIFEST_VERSION);
        if (string == null) {
            string = "1.0";
        }
        JarUtils.writeHeader(Attributes.Name.MANIFEST_VERSION.toString(), string, outputStream);
    }

    private static void writeAttributeEntry(Map.Entry entry, OutputStream outputStream) throws IOException {
        String string = entry.getKey().toString();
        String string2 = entry.getValue().toString();
        if (string.equalsIgnoreCase(NAME)) {
            throw new JarException("Attributes cannot be called 'Name'");
        }
        if (string.startsWith("From")) {
            throw new JarException("Header cannot start with the four letters 'From'" + string);
        }
        JarUtils.writeHeader(string, string2, outputStream);
    }

    private static void writeHeader(String string, String string2, OutputStream outputStream) throws IOException {
        String string3 = string + ": ";
        byte[] byArray = string3.getBytes("UTF-8");
        if (byArray.length > 72) {
            throw new IOException("Attribute's name already longer than 70 bytes");
        }
        if (byArray.length == 72) {
            outputStream.write(byArray);
            outputStream.write(CRLF);
            string3 = " " + string2;
        } else {
            string3 = string3 + string2;
        }
        while (true) {
            if ((byArray = string3.getBytes("UTF-8")).length < 73) break;
            int n = 72;
            while ((byArray = string3.substring(0, n).getBytes("UTF-8")).length >= 73) {
                if (--n >= 1) continue;
                throw new IOException("Header is unbreakable and longer than 72 bytes");
            }
            outputStream.write(byArray);
            outputStream.write(CRLF);
            string3 = " " + string3.substring(n);
        }
        outputStream.write(byArray);
        outputStream.write(CRLF);
    }
}

