/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509.ext;

import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.x509.ext.Extension;
import gnu.java.security.x509.ext.GeneralSubtree;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameConstraints
extends Extension.Value {
    public static final OID ID = new OID("2.5.29.30");
    private List<GeneralSubtree> permittedSubtrees;
    private List<GeneralSubtree> excludedSubtrees;

    public NameConstraints(byte[] byArray) throws IOException {
        super(byArray);
        DERReader dERReader = new DERReader(byArray);
        DERValue dERValue = dERReader.read();
        if (!dERValue.isConstructed()) {
            throw new IOException("malformed NameConstraints");
        }
        this.permittedSubtrees = new LinkedList<GeneralSubtree>();
        this.excludedSubtrees = new LinkedList<GeneralSubtree>();
        int n = 0;
        if (n < dERValue.getLength()) {
            DERValue dERValue2 = dERReader.read();
            if (dERValue2.getTag() == 0) {
                int n2;
                DERValue dERValue3;
                for (n2 = 0; n2 < dERValue2.getLength(); n2 += dERValue3.getEncodedLength()) {
                    dERValue3 = dERReader.read();
                    this.permittedSubtrees.add(new GeneralSubtree(dERValue3.getEncoded()));
                    dERReader.skip(dERValue3.getLength());
                }
                if ((n += dERValue2.getEncodedLength()) < dERValue.getLength()) {
                    dERValue2 = dERReader.read();
                    if (dERValue2.getTag() != 1) {
                        throw new IOException("unexpected tag " + dERValue2.getTag() + " (expecting 1 for excludedSubtrees)");
                    }
                    for (n2 = 0; n2 < dERValue2.getLength(); n2 += dERValue3.getEncodedLength()) {
                        dERValue3 = dERReader.read();
                        this.excludedSubtrees.add(new GeneralSubtree(dERValue3.getEncoded()));
                        dERReader.skip(dERValue3.getLength());
                    }
                }
            } else if (dERValue2.getTag() == 1) {
                DERValue dERValue4;
                for (int i = 0; i < dERValue2.getLength(); i += dERValue4.getEncodedLength()) {
                    dERValue4 = dERReader.read();
                    this.excludedSubtrees.add(new GeneralSubtree(dERValue4.getEncoded()));
                    dERReader.skip(dERValue4.getLength());
                }
            } else {
                throw new IOException("unexpected tag " + dERValue2.getTag() + " (expecting 0 or 1)");
            }
        }
    }

    public List<GeneralSubtree> permittedSubtrees() {
        return Collections.unmodifiableList(this.permittedSubtrees);
    }

    public List<GeneralSubtree> excludedSubtrees() {
        return Collections.unmodifiableList(this.excludedSubtrees);
    }

    @Override
    public String toString() {
        return NameConstraints.class.getName() + " [ permittedSubtrees=" + this.permittedSubtrees + "; excludedSubtrees=" + this.excludedSubtrees + " ]";
    }
}

