/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509.ext;

import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.x509.ext.Extension;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedKeyUsage
extends Extension.Value {
    public static final OID ID = new OID("2.5.29.37");
    private final List<OID> purposeIds;

    public ExtendedKeyUsage(byte[] byArray) throws IOException {
        super(byArray);
        DERValue dERValue;
        DERReader dERReader = new DERReader(byArray);
        DERValue dERValue2 = dERReader.read();
        if (!dERValue2.isConstructed()) {
            throw new IOException("malformed ExtKeyUsageSyntax");
        }
        this.purposeIds = new LinkedList<OID>();
        for (int i = 0; i < dERValue2.getLength(); i += dERValue.getEncodedLength()) {
            dERValue = dERReader.read();
            if (dERValue.getTag() != 6) {
                throw new IOException("malformed KeyPurposeId");
            }
            this.purposeIds.add((OID)dERValue.getValue());
        }
    }

    public List<OID> getPurposeIds() {
        return Collections.unmodifiableList(this.purposeIds);
    }

    @Override
    public String toString() {
        return ExtendedKeyUsage.class.getName() + " [ " + this.purposeIds + " ]";
    }
}

