/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509.ext;

import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.x509.ext.Extension;
import java.io.IOException;
import java.security.cert.PolicyQualifierInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificatePolicies
extends Extension.Value {
    public static final OID ID = new OID("2.5.29.32");
    private final List<OID> policies;
    private final Map<OID, List<PolicyQualifierInfo>> policyQualifierInfos;

    public CertificatePolicies(byte[] byArray) throws IOException {
        super(byArray);
        DERValue dERValue;
        DERReader dERReader = new DERReader(byArray);
        DERValue dERValue2 = dERReader.read();
        if (!dERValue2.isConstructed()) {
            throw new IOException("malformed CertificatePolicies");
        }
        LinkedList<OID> linkedList = new LinkedList<OID>();
        HashMap hashMap = new HashMap();
        for (int i = 0; i < dERValue2.getLength(); i += dERValue.getEncodedLength()) {
            dERValue = dERReader.read();
            if (!dERValue.isConstructed()) {
                throw new IOException("malformed PolicyInformation");
            }
            DERValue dERValue3 = dERReader.read();
            if (dERValue3.getTag() != 6) {
                throw new IOException("malformed CertPolicyId");
            }
            OID oID = (OID)dERValue3.getValue();
            linkedList.add(oID);
            if (dERValue3.getEncodedLength() >= dERValue.getLength()) continue;
            DERValue dERValue4 = dERReader.read();
            LinkedList<PolicyQualifierInfo> linkedList2 = new LinkedList<PolicyQualifierInfo>();
            for (int j = 0; j < dERValue4.getLength(); j += dERValue3.getEncodedLength()) {
                dERValue3 = dERReader.read();
                linkedList2.add(new PolicyQualifierInfo(dERValue3.getEncoded()));
                dERReader.skip(dERValue3.getLength());
            }
            hashMap.put(oID, linkedList2);
        }
        this.policies = Collections.unmodifiableList(linkedList);
        this.policyQualifierInfos = Collections.unmodifiableMap(hashMap);
    }

    public CertificatePolicies(List<OID> list2, Map<OID, List<PolicyQualifierInfo>> map) {
        Iterator<Object> iterator = list2.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof OID) continue;
            throw new IllegalArgumentException("policies must be OIDs");
        }
        iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (!(entry.getKey() instanceof OID) || !list2.contains(entry.getKey())) {
                throw new IllegalArgumentException("policyQualifierInfos keys must be OIDs");
            }
            if (!(entry.getValue() instanceof List)) {
                throw new IllegalArgumentException("policyQualifierInfos values must be Lists of PolicyQualifierInfos");
            }
            Iterator iterator2 = ((List)entry.getValue()).iterator();
            while (iterator.hasNext()) {
                if (iterator2.next() instanceof PolicyQualifierInfo) continue;
                throw new IllegalArgumentException("policyQualifierInfos values must be Lists of PolicyQualifierInfos");
            }
        }
        this.policies = Collections.unmodifiableList(new ArrayList<OID>(list2));
        this.policyQualifierInfos = Collections.unmodifiableMap(new HashMap<OID, List<PolicyQualifierInfo>>(map));
    }

    public List<OID> getPolicies() {
        return this.policies;
    }

    public List<String> getPolicyStrings() {
        ArrayList<String> arrayList = new ArrayList<String>(this.policies.size());
        for (OID oID : this.policies) {
            arrayList.add(oID.toString());
        }
        return arrayList;
    }

    public List<PolicyQualifierInfo> getPolicyQualifierInfos(OID oID) {
        return this.policyQualifierInfos.get(oID);
    }

    @Override
    public byte[] getEncoded() {
        if (this.encoded == null) {
            ArrayList<DERValue> arrayList = new ArrayList<DERValue>(this.policies.size());
            Iterator<OID> iterator = this.policies.iterator();
            while (iterator.hasNext()) {
                OID oID = iterator.next();
                List<PolicyQualifierInfo> list2 = this.getPolicyQualifierInfos(oID);
                ArrayList<DERValue> arrayList2 = new ArrayList<DERValue>(list2 == null ? 1 : 2);
                arrayList2.add(new DERValue(6, oID));
                if (list2 != null) {
                    ArrayList<DERValue> arrayList3 = new ArrayList<DERValue>(list2.size());
                    Iterator<PolicyQualifierInfo> iterator2 = list2.iterator();
                    while (iterator.hasNext()) {
                        PolicyQualifierInfo policyQualifierInfo = iterator2.next();
                        try {
                            arrayList3.add(DERReader.read(policyQualifierInfo.getEncoded()));
                        }
                        catch (IOException iOException) {}
                    }
                    arrayList2.add(new DERValue(48, arrayList3));
                }
                arrayList.add(new DERValue(48, arrayList2));
            }
            this.encoded = new DERValue(48, arrayList).getEncoded();
        }
        return (byte[])this.encoded.clone();
    }

    @Override
    public String toString() {
        return CertificatePolicies.class.getName() + " [ policies=" + this.policies + " policyQualifierInfos=" + this.policyQualifierInfos + " ]";
    }
}

