/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509;

import gnu.classpath.debug.Component;
import gnu.classpath.debug.SystemLogger;
import gnu.java.security.OID;
import gnu.java.security.der.BitString;
import gnu.java.security.der.DER;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.x509.GnuPKIExtension;
import gnu.java.security.x509.Util;
import gnu.java.security.x509.X500DistinguishedName;
import gnu.java.security.x509.ext.BasicConstraints;
import gnu.java.security.x509.ext.ExtendedKeyUsage;
import gnu.java.security.x509.ext.Extension;
import gnu.java.security.x509.ext.GeneralName;
import gnu.java.security.x509.ext.IssuerAlternativeNames;
import gnu.java.security.x509.ext.KeyUsage;
import gnu.java.security.x509.ext.SubjectAlternativeNames;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.x500.X500Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X509Certificate
extends java.security.cert.X509Certificate
implements Serializable,
GnuPKIExtension {
    private static final long serialVersionUID = -2491127588187038216L;
    private static final Logger logger = SystemLogger.SYSTEM;
    protected static final OID ID_DSA = new OID("1.2.840.10040.4.1");
    protected static final OID ID_DSA_WITH_SHA1 = new OID("1.2.840.10040.4.3");
    protected static final OID ID_RSA = new OID("1.2.840.113549.1.1.1");
    protected static final OID ID_RSA_WITH_MD2 = new OID("1.2.840.113549.1.1.2");
    protected static final OID ID_RSA_WITH_MD5 = new OID("1.2.840.113549.1.1.4");
    protected static final OID ID_RSA_WITH_SHA1 = new OID("1.2.840.113549.1.1.5");
    protected static final OID ID_ECDSA_WITH_SHA1 = new OID("1.2.840.10045.4.1");
    protected transient byte[] encoded;
    protected transient byte[] tbsCertBytes;
    protected transient int version;
    protected transient BigInteger serialNo;
    protected transient OID algId;
    protected transient byte[] algVal;
    protected transient X500DistinguishedName issuer;
    protected transient Date notBefore;
    protected transient Date notAfter;
    protected transient X500DistinguishedName subject;
    protected transient PublicKey subjectKey;
    protected transient BitString issuerUniqueId;
    protected transient BitString subjectUniqueId;
    protected transient Map<OID, Extension> extensions = new HashMap<OID, Extension>();
    protected transient OID sigAlgId;
    protected transient byte[] sigAlgVal;
    protected transient byte[] signature;

    public X509Certificate(InputStream inputStream) throws CertificateException, IOException {
        try {
            this.parse(inputStream);
        }
        catch (IOException iOException) {
            logger.log((Level)Component.X509, "", iOException);
            throw iOException;
        }
        catch (Exception exception) {
            logger.log((Level)Component.X509, "", exception);
            CertificateException certificateException = new CertificateException(exception.getMessage());
            certificateException.initCause(exception);
            throw certificateException;
        }
    }

    protected X509Certificate() {
    }

    @Override
    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(new Date());
    }

    @Override
    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (date.compareTo(this.notBefore) < 0) {
            throw new CertificateNotYetValidException();
        }
        if (date.compareTo(this.notAfter) > 0) {
            throw new CertificateExpiredException();
        }
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.serialNo;
    }

    @Override
    public Principal getIssuerDN() {
        return this.issuer;
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        return new X500Principal(this.issuer.getDer());
    }

    @Override
    public Principal getSubjectDN() {
        return this.subject;
    }

    @Override
    public X500Principal getSubjectX500Principal() {
        return new X500Principal(this.subject.getDer());
    }

    @Override
    public Date getNotBefore() {
        return (Date)this.notBefore.clone();
    }

    @Override
    public Date getNotAfter() {
        return (Date)this.notAfter.clone();
    }

    @Override
    public byte[] getTBSCertificate() throws CertificateEncodingException {
        return (byte[])this.tbsCertBytes.clone();
    }

    @Override
    public byte[] getSignature() {
        return (byte[])this.signature.clone();
    }

    @Override
    public String getSigAlgName() {
        if (this.sigAlgId.equals(ID_DSA_WITH_SHA1)) {
            return "SHA1withDSA";
        }
        if (this.sigAlgId.equals(ID_RSA_WITH_MD2)) {
            return "MD2withRSA";
        }
        if (this.sigAlgId.equals(ID_RSA_WITH_MD5)) {
            return "MD5withRSA";
        }
        if (this.sigAlgId.equals(ID_RSA_WITH_SHA1)) {
            return "SHA1withRSA";
        }
        return "unknown";
    }

    @Override
    public String getSigAlgOID() {
        return this.sigAlgId.toString();
    }

    @Override
    public byte[] getSigAlgParams() {
        return (byte[])this.sigAlgVal.clone();
    }

    @Override
    public boolean[] getIssuerUniqueID() {
        if (this.issuerUniqueId != null) {
            return this.issuerUniqueId.toBooleanArray();
        }
        return null;
    }

    @Override
    public boolean[] getSubjectUniqueID() {
        if (this.subjectUniqueId != null) {
            return this.subjectUniqueId.toBooleanArray();
        }
        return null;
    }

    @Override
    public boolean[] getKeyUsage() {
        Extension extension = this.getExtension(KeyUsage.ID);
        if (extension != null) {
            KeyUsage keyUsage = (KeyUsage)extension.getValue();
            boolean[] blArray = new boolean[9];
            boolean[] blArray2 = keyUsage.getKeyUsage().toBooleanArray();
            System.arraycopy(blArray2, 0, blArray, 0, blArray2.length);
            return blArray;
        }
        return null;
    }

    @Override
    public List<String> getExtendedKeyUsage() throws CertificateParsingException {
        Extension extension = this.getExtension(ExtendedKeyUsage.ID);
        if (extension != null) {
            List<OID> list2 = ((ExtendedKeyUsage)extension.getValue()).getPurposeIds();
            ArrayList<String> arrayList = new ArrayList<String>(list2.size());
            for (OID oID : list2) {
                arrayList.add(oID.toString());
            }
            return Collections.unmodifiableList(arrayList);
        }
        return null;
    }

    @Override
    public int getBasicConstraints() {
        Extension extension = this.getExtension(BasicConstraints.ID);
        if (extension != null) {
            return ((BasicConstraints)extension.getValue()).getPathLengthConstraint();
        }
        return -1;
    }

    @Override
    public Collection<List<?>> getSubjectAlternativeNames() throws CertificateParsingException {
        Extension extension = this.getExtension(SubjectAlternativeNames.ID);
        if (extension != null) {
            List<GeneralName> list2 = ((SubjectAlternativeNames)extension.getValue()).getNames();
            ArrayList arrayList = new ArrayList(list2.size());
            for (GeneralName generalName : list2) {
                ArrayList<Object> arrayList2 = new ArrayList<Object>(2);
                arrayList2.add(generalName.kind().tag());
                arrayList2.add(generalName.name());
                arrayList.add(arrayList2);
            }
            return arrayList;
        }
        return null;
    }

    @Override
    public Collection<List<?>> getIssuerAlternativeNames() throws CertificateParsingException {
        Extension extension = this.getExtension(IssuerAlternativeNames.ID);
        if (extension != null) {
            List<GeneralName> list2 = ((IssuerAlternativeNames)extension.getValue()).getNames();
            ArrayList arrayList = new ArrayList(list2.size());
            for (GeneralName generalName : list2) {
                ArrayList<Object> arrayList2 = new ArrayList<Object>(2);
                arrayList2.add(generalName.kind().tag());
                arrayList2.add(generalName.name());
                arrayList.add(arrayList2);
            }
            return arrayList;
        }
        return null;
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        for (Extension extension : this.extensions.values()) {
            if (!extension.isCritical() || extension.isSupported()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Extension extension : this.extensions.values()) {
            if (!extension.isCritical()) continue;
            hashSet.add(extension.getOid().toString());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Extension extension : this.extensions.values()) {
            if (extension.isCritical()) continue;
            hashSet.add(extension.getOid().toString());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public byte[] getExtensionValue(String string) {
        Extension extension = this.getExtension(new OID(string));
        if (extension != null) {
            return extension.getValue().getEncoded();
        }
        return null;
    }

    @Override
    public Extension getExtension(OID oID) {
        return this.extensions.get(oID);
    }

    @Override
    public Collection getExtensions() {
        return this.extensions.values();
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        return (byte[])this.encoded.clone();
    }

    @Override
    public void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature = Signature.getInstance(this.sigAlgId.toString());
        this.doVerify(signature, publicKey);
    }

    @Override
    public void verify(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature = Signature.getInstance(this.sigAlgId.toString(), string);
        this.doVerify(signature, publicKey);
    }

    @Override
    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println(X509Certificate.class.getName() + " {");
        printWriter.println("  TBSCertificate {");
        printWriter.println("    version = " + this.version + ";");
        printWriter.println("    serialNo = " + this.serialNo + ";");
        printWriter.println("    signature = {");
        printWriter.println("      algorithm = " + this.getSigAlgName() + ";");
        printWriter.print("      parameters =");
        if (this.sigAlgVal != null) {
            printWriter.println();
            printWriter.print(Util.hexDump(this.sigAlgVal, "        "));
        } else {
            printWriter.println(" null;");
        }
        printWriter.println("    }");
        printWriter.println("    issuer = " + this.issuer.getName() + ";");
        printWriter.println("    validity = {");
        printWriter.println("      notBefore = " + this.notBefore + ";");
        printWriter.println("      notAfter  = " + this.notAfter + ";");
        printWriter.println("    }");
        printWriter.println("    subject = " + this.subject.getName() + ";");
        printWriter.println("    subjectPublicKeyInfo = {");
        printWriter.println("      algorithm = " + this.subjectKey.getAlgorithm());
        printWriter.println("      key =");
        printWriter.print(Util.hexDump(this.subjectKey.getEncoded(), "        "));
        printWriter.println("    };");
        printWriter.println("    issuerUniqueId  = " + this.issuerUniqueId + ";");
        printWriter.println("    subjectUniqueId = " + this.subjectUniqueId + ";");
        printWriter.println("    extensions = {");
        Iterator<Extension> iterator = this.extensions.values().iterator();
        while (iterator.hasNext()) {
            printWriter.println("      " + iterator.next());
        }
        printWriter.println("    }");
        printWriter.println("  }");
        printWriter.println("  signatureAlgorithm = " + this.getSigAlgName() + ";");
        printWriter.println("  signatureValue =");
        printWriter.print(Util.hexDump(this.signature, "    "));
        printWriter.println("}");
        return stringWriter.toString();
    }

    @Override
    public PublicKey getPublicKey() {
        return this.subjectKey;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof X509Certificate)) {
            return false;
        }
        try {
            if (object instanceof X509Certificate) {
                return Arrays.equals(this.encoded, ((X509Certificate)object).encoded);
            }
            byte[] byArray = ((X509Certificate)object).getEncoded();
            if (byArray == null) {
                return false;
            }
            return Arrays.equals(this.encoded, byArray);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return false;
        }
    }

    private void doVerify(Signature signature, PublicKey publicKey) throws CertificateException, InvalidKeyException, SignatureException {
        logger.log((Level)Component.X509, "verifying sig={0} key={1}", new Object[]{signature, publicKey});
        signature.initVerify(publicKey);
        signature.update(this.tbsCertBytes);
        if (!signature.verify(this.signature)) {
            throw new CertificateException("signature not validated");
        }
    }

    private void parse(InputStream inputStream) throws Exception {
        Object object;
        Object object2;
        byte[] byArray;
        DERReader dERReader = new DERReader(inputStream);
        DERValue dERValue = dERReader.read();
        logger.log((Level)Component.X509, "start Certificate  len == {0}", dERValue.getLength());
        this.encoded = dERValue.getEncoded();
        if (!dERValue.isConstructed()) {
            throw new IOException("malformed Certificate");
        }
        DERValue dERValue2 = dERReader.read();
        if (dERValue2.getValue() != DER.CONSTRUCTED_VALUE) {
            throw new IOException("malformed TBSCertificate");
        }
        this.tbsCertBytes = dERValue2.getEncoded();
        logger.log((Level)Component.X509, "start TBSCertificate  len == {0}", dERValue2.getLength());
        DERValue dERValue3 = dERReader.read();
        if (dERValue3.getTagClass() == 128 && dERValue3.getTag() == 0) {
            this.version = ((BigInteger)dERReader.read().getValue()).intValue() + 1;
            dERValue3 = dERReader.read();
        } else {
            this.version = 1;
        }
        logger.log((Level)Component.X509, "read version == {0}", this.version);
        this.serialNo = (BigInteger)dERValue3.getValue();
        logger.log((Level)Component.X509, "read serial number == {0}", this.serialNo);
        dERValue3 = dERReader.read();
        if (!dERValue3.isConstructed()) {
            throw new IOException("malformed AlgorithmIdentifier");
        }
        int n = dERValue3.getLength();
        logger.log((Level)Component.X509, "start AlgorithmIdentifier  len == {0}", n);
        dERValue3 = dERReader.read();
        this.algId = (OID)dERValue3.getValue();
        logger.log((Level)Component.X509, "read algorithm ID == {0}", this.algId);
        if (n > dERValue3.getEncodedLength()) {
            dERValue3 = dERReader.read();
            if (dERValue3 == null) {
                this.algVal = null;
            } else {
                this.algVal = dERValue3.getEncoded();
                if (dERValue3.isConstructed()) {
                    inputStream.skip(dERValue3.getLength());
                }
            }
            logger.log((Level)Component.X509, "read algorithm parameters == {0}", (Object)this.algVal);
        }
        dERValue3 = dERReader.read();
        this.issuer = new X500DistinguishedName(dERValue3.getEncoded());
        dERReader.skip(dERValue3.getLength());
        logger.log((Level)Component.X509, "read issuer == {0}", this.issuer);
        if (!dERReader.read().isConstructed()) {
            throw new IOException("malformed Validity");
        }
        this.notBefore = (Date)dERReader.read().getValue();
        logger.log((Level)Component.X509, "read notBefore == {0}", this.notBefore);
        this.notAfter = (Date)dERReader.read().getValue();
        logger.log((Level)Component.X509, "read notAfter == {0}", this.notAfter);
        dERValue3 = dERReader.read();
        this.subject = new X500DistinguishedName(dERValue3.getEncoded());
        dERReader.skip(dERValue3.getLength());
        logger.log((Level)Component.X509, "read subject == {0}", this.subject);
        DERValue dERValue4 = dERReader.read();
        if (!dERValue4.isConstructed()) {
            throw new IOException("malformed SubjectPublicKeyInfo");
        }
        KeyFactory keyFactory = KeyFactory.getInstance("X.509");
        this.subjectKey = keyFactory.generatePublic(new X509EncodedKeySpec(dERValue4.getEncoded()));
        dERReader.skip(dERValue4.getLength());
        logger.log((Level)Component.X509, "read subjectPublicKey == {0}", this.subjectKey);
        dERValue3 = dERReader.read();
        if (this.version >= 2 && dERValue3.getTagClass() != 0 && dERValue3.getTag() == 1) {
            byArray = (byte[])dERValue3.getValue();
            this.issuerUniqueId = new BitString(byArray, 1, byArray.length - 1, byArray[0] & 0xFF);
            logger.log((Level)Component.X509, "read issuerUniqueId == {0}", this.issuerUniqueId);
            dERValue3 = dERReader.read();
        }
        if (this.version >= 2 && dERValue3.getTagClass() != 0 && dERValue3.getTag() == 2) {
            byArray = (byte[])dERValue3.getValue();
            this.subjectUniqueId = new BitString(byArray, 1, byArray.length - 1, byArray[0] & 0xFF);
            logger.log((Level)Component.X509, "read subjectUniqueId == {0}", this.subjectUniqueId);
            dERValue3 = dERReader.read();
        }
        if (this.version >= 3 && dERValue3.getTagClass() != 0 && dERValue3.getTag() == 3) {
            dERValue3 = dERReader.read();
            logger.log((Level)Component.X509, "start Extensions  len == {0}", dERValue3.getLength());
            int n2 = 0;
            while (n2 < dERValue3.getLength()) {
                object2 = dERReader.read();
                logger.log((Level)Component.X509, "start extension  len == {0}", ((DERValue)object2).getLength());
                object = new Extension(((DERValue)object2).getEncoded());
                this.extensions.put(((Extension)object).getOid(), (Extension)object);
                dERReader.skip(((DERValue)object2).getLength());
                logger.log((Level)Component.X509, "read extension {0} == {1}", new Object[]{((Extension)object).getOid(), object});
                logger.log((Level)Component.X509, "count == {0}", n2 += ((DERValue)object2).getEncodedLength());
            }
            dERValue3 = dERReader.read();
        }
        logger.log((Level)Component.X509, "read value {0}", dERValue3);
        if (!dERValue3.isConstructed()) {
            throw new CertificateException("malformed AlgorithmIdentifier");
        }
        int n3 = dERValue3.getLength();
        logger.log((Level)Component.X509, "start AlgorithmIdentifier  len == {0}", n3);
        dERValue3 = dERReader.read();
        this.sigAlgId = (OID)dERValue3.getValue();
        logger.log((Level)Component.X509, "read algorithm id == {0}", this.sigAlgId);
        if (n3 > dERValue3.getEncodedLength()) {
            dERValue3 = dERReader.read();
            if (dERValue3.getValue() == null) {
                if (this.subjectKey instanceof DSAPublicKey) {
                    object2 = AlgorithmParameters.getInstance("DSA");
                    object = ((DSAPublicKey)this.subjectKey).getParams();
                    DSAParameterSpec dSAParameterSpec = new DSAParameterSpec(object.getP(), object.getQ(), object.getG());
                    ((AlgorithmParameters)object2).init(dSAParameterSpec);
                    this.sigAlgVal = ((AlgorithmParameters)object2).getEncoded();
                }
            } else {
                this.sigAlgVal = dERValue3.getEncoded();
            }
            if (dERValue3.isConstructed()) {
                inputStream.skip(dERValue3.getLength());
            }
            logger.log((Level)Component.X509, "read parameters == {0}", (Object)this.sigAlgVal);
        }
        this.signature = ((BitString)dERReader.read().getValue()).toByteArray();
        logger.log((Level)Component.X509, "read signature ==\n{0}", Util.hexDump(this.signature, ">>>> "));
    }
}

