/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509;

import gnu.java.lang.CPStringBuilder;
import java.security.cert.PolicyNode;
import java.security.cert.PolicyQualifierInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class PolicyNodeImpl
implements PolicyNode {
    private String policy;
    private final Set expectedPolicies = new HashSet();
    private final Set qualifiers = new HashSet();
    private final Set children = new HashSet();
    private PolicyNodeImpl parent;
    private int depth;
    private boolean critical = false;
    private boolean readOnly = false;

    public void addChild(PolicyNodeImpl policyNodeImpl) {
        if (this.readOnly) {
            throw new IllegalStateException("read only");
        }
        if (policyNodeImpl.getParent() != null) {
            throw new IllegalStateException("already a child node");
        }
        policyNodeImpl.parent = this;
        policyNodeImpl.setDepth(this.depth + 1);
        this.children.add(policyNodeImpl);
    }

    public Iterator getChildren() {
        return Collections.unmodifiableSet(this.children).iterator();
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int n) {
        if (this.readOnly) {
            throw new IllegalStateException("read only");
        }
        this.depth = n;
    }

    public void addAllExpectedPolicies(Set set) {
        if (this.readOnly) {
            throw new IllegalStateException("read only");
        }
        this.expectedPolicies.addAll(set);
    }

    public void addExpectedPolicy(String string) {
        if (this.readOnly) {
            throw new IllegalStateException("read only");
        }
        this.expectedPolicies.add(string);
    }

    public Set getExpectedPolicies() {
        return Collections.unmodifiableSet(this.expectedPolicies);
    }

    public PolicyNode getParent() {
        return this.parent;
    }

    public void addAllPolicyQualifiers(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof PolicyQualifierInfo) continue;
            throw new IllegalArgumentException("can only add PolicyQualifierInfos");
        }
        collection.addAll(collection);
    }

    public void addPolicyQualifier(PolicyQualifierInfo policyQualifierInfo) {
        if (this.readOnly) {
            throw new IllegalStateException("read only");
        }
        this.qualifiers.add(policyQualifierInfo);
    }

    public Set getPolicyQualifiers() {
        return Collections.unmodifiableSet(this.qualifiers);
    }

    public String getValidPolicy() {
        return this.policy;
    }

    public void setValidPolicy(String string) {
        if (this.readOnly) {
            throw new IllegalStateException("read only");
        }
        this.policy = string;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public void setCritical(boolean bl) {
        if (this.readOnly) {
            throw new IllegalStateException("read only");
        }
        this.critical = bl;
    }

    public void setReadOnly() {
        if (this.readOnly) {
            return;
        }
        this.readOnly = true;
        Iterator iterator = this.getChildren();
        while (iterator.hasNext()) {
            ((PolicyNodeImpl)iterator.next()).setReadOnly();
        }
    }

    public String toString() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        for (int i = 0; i < this.depth; ++i) {
            cPStringBuilder.append("  ");
        }
        cPStringBuilder.append("(");
        cPStringBuilder.append(PolicyNodeImpl.class.getName());
        cPStringBuilder.append(" (oid ");
        cPStringBuilder.append(this.policy);
        cPStringBuilder.append(") (depth ");
        cPStringBuilder.append(this.depth);
        cPStringBuilder.append(") (qualifiers ");
        cPStringBuilder.append(this.qualifiers);
        cPStringBuilder.append(") (critical ");
        cPStringBuilder.append(this.critical);
        cPStringBuilder.append(") (expectedPolicies ");
        cPStringBuilder.append(this.expectedPolicies);
        cPStringBuilder.append(") (children (");
        String string = System.getProperty("line.separator");
        Iterator iterator = this.getChildren();
        while (iterator.hasNext()) {
            cPStringBuilder.append(string);
            cPStringBuilder.append(iterator.next().toString());
        }
        cPStringBuilder.append(")))");
        return cPStringBuilder.toString();
    }
}

