/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.sig.rsa;

import gnu.java.security.hash.HashFactory;
import gnu.java.security.hash.IMessageDigest;
import java.io.ByteArrayOutputStream;

public class EMSA_PKCS1_V1_5
implements Cloneable {
    private static final byte[] MD2_PREFIX = new byte[]{48, 32, 48, 12, 6, 8, 42, -122, 72, -122, -9, 13, 2, 2, 5, 0, 4, 16};
    private static final byte[] MD5_PREFIX = new byte[]{48, 32, 48, 12, 6, 8, 42, -122, 72, -122, -9, 13, 2, 5, 5, 0, 4, 16};
    private static final byte[] SHA160_PREFIX = new byte[]{48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20};
    private static final byte[] SHA256_PREFIX = new byte[]{48, 49, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 1, 5, 0, 4, 32};
    private static final byte[] SHA384_PREFIX = new byte[]{48, 65, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 2, 5, 0, 4, 48};
    private static final byte[] SHA512_PREFIX = new byte[]{48, 81, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 3, 5, 0, 4, 64};
    private IMessageDigest hash;
    private int hLen;
    private byte[] prefix;

    private EMSA_PKCS1_V1_5(IMessageDigest iMessageDigest) {
        this.hash = iMessageDigest;
        this.hLen = iMessageDigest.hashSize();
        String string = iMessageDigest.name();
        if (string.equals("md2")) {
            this.prefix = MD2_PREFIX;
        } else if (string.equals("md5")) {
            this.prefix = MD5_PREFIX;
        } else if (string.equals("sha-160")) {
            this.prefix = SHA160_PREFIX;
        } else if (string.equals("sha-256")) {
            this.prefix = SHA256_PREFIX;
        } else if (string.equals("sha-384")) {
            this.prefix = SHA384_PREFIX;
        } else if (string.equals("sha-512")) {
            this.prefix = SHA512_PREFIX;
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static final EMSA_PKCS1_V1_5 getInstance(String string) {
        IMessageDigest iMessageDigest = HashFactory.getInstance(string);
        String string2 = iMessageDigest.name();
        if (!(string2.equals("md2") || string2.equals("md5") || string2.equals("sha-160") || string2.equals("sha-256") || string2.equals("sha-384") || string2.equals("sha-512"))) {
            throw new UnsupportedOperationException("hash with no OID: " + string2);
        }
        return new EMSA_PKCS1_V1_5(iMessageDigest);
    }

    public Object clone() {
        return EMSA_PKCS1_V1_5.getInstance(this.hash.name());
    }

    public byte[] encode(byte[] byArray, int n) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(this.prefix, 0, this.prefix.length);
        byteArrayOutputStream.write(byArray, 0, byArray.length);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        int n2 = byArray2.length;
        if (n < n2 + 11) {
            throw new IllegalArgumentException("emLen too short");
        }
        byte[] byArray3 = new byte[n - n2 - 3];
        for (int i = 0; i < byArray3.length; ++i) {
            byArray3[i] = -1;
        }
        byteArrayOutputStream.reset();
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(1);
        byteArrayOutputStream.write(byArray3, 0, byArray3.length);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(byArray2, 0, n2);
        byte[] byArray4 = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.reset();
        return byArray4;
    }
}

