/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.sig;

import gnu.java.security.hash.IMessageDigest;
import gnu.java.security.prng.IRandom;
import gnu.java.security.prng.LimitReachedException;
import gnu.java.security.sig.ISignature;
import gnu.java.security.util.PRNG;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Map;
import java.util.Random;

public abstract class BaseSignature
implements ISignature {
    protected String schemeName;
    protected IMessageDigest md;
    protected PublicKey publicKey;
    protected PrivateKey privateKey;
    private Random rnd;
    private IRandom irnd;
    private PRNG prng = null;

    protected BaseSignature(String string, IMessageDigest iMessageDigest) {
        this.schemeName = string;
        if (iMessageDigest == null) {
            throw new IllegalArgumentException("Message digest MUST NOT be null");
        }
        this.md = iMessageDigest;
    }

    public String name() {
        return this.schemeName + "-" + this.md.name();
    }

    public void setupVerify(Map map) throws IllegalArgumentException {
        this.setup(map);
        PublicKey publicKey = (PublicKey)map.get("gnu.crypto.sig.public.key");
        if (publicKey != null) {
            this.setupForVerification(publicKey);
        }
    }

    public void setupSign(Map map) throws IllegalArgumentException {
        this.setup(map);
        PrivateKey privateKey = (PrivateKey)map.get("gnu.crypto.sig.private.key");
        if (privateKey != null) {
            this.setupForSigning(privateKey);
        }
    }

    public void update(byte by) {
        if (this.md == null) {
            throw new IllegalStateException();
        }
        this.md.update(by);
    }

    public void update(byte[] byArray, int n, int n2) {
        if (this.md == null) {
            throw new IllegalStateException();
        }
        this.md.update(byArray, n, n2);
    }

    public Object sign() {
        if (this.md == null || this.privateKey == null) {
            throw new IllegalStateException();
        }
        return this.generateSignature();
    }

    public boolean verify(Object object) {
        if (this.md == null || this.publicKey == null) {
            throw new IllegalStateException();
        }
        return this.verifySignature(object);
    }

    public abstract Object clone();

    protected abstract void setupForVerification(PublicKey var1) throws IllegalArgumentException;

    protected abstract void setupForSigning(PrivateKey var1) throws IllegalArgumentException;

    protected abstract Object generateSignature() throws IllegalStateException;

    protected abstract boolean verifySignature(Object var1) throws IllegalStateException;

    protected void init() {
        this.md.reset();
        this.rnd = null;
        this.irnd = null;
        this.publicKey = null;
        this.privateKey = null;
    }

    protected void nextRandomBytes(byte[] byArray) {
        if (this.rnd != null) {
            this.rnd.nextBytes(byArray);
        } else if (this.irnd != null) {
            try {
                this.irnd.nextBytes(byArray, 0, byArray.length);
            }
            catch (IllegalStateException illegalStateException) {
                throw new RuntimeException("nextRandomBytes(): " + illegalStateException);
            }
            catch (LimitReachedException limitReachedException) {
                throw new RuntimeException("nextRandomBytes(): " + limitReachedException);
            }
        } else {
            this.getDefaultPRNG().nextBytes(byArray);
        }
    }

    private void setup(Map map) {
        this.init();
        Object v = map.get("gnu.crypto.sig.prng");
        if (v instanceof Random) {
            this.rnd = (Random)v;
        } else if (v instanceof IRandom) {
            this.irnd = (IRandom)v;
        }
    }

    private PRNG getDefaultPRNG() {
        if (this.prng == null) {
            this.prng = PRNG.getInstance();
        }
        return this.prng;
    }
}

