/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.provider;

import gnu.java.io.Base64InputStream;
import gnu.java.lang.CPStringBuilder;
import gnu.java.security.x509.X509CRL;
import gnu.java.security.x509.X509CertPath;
import gnu.java.security.x509.X509Certificate;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class X509CertificateFactory
extends CertificateFactorySpi {
    public static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERTIFICATE = "-----END CERTIFICATE-----";
    public static final String BEGIN_X509_CRL = "-----BEGIN X509 CRL-----";
    public static final String END_X509_CRL = "-----END X509 CRL-----";

    public Certificate engineGenerateCertificate(InputStream inputStream) throws CertificateException {
        try {
            return this.generateCert(inputStream);
        }
        catch (IOException iOException) {
            CertificateException certificateException = new CertificateException(iOException.getMessage());
            certificateException.initCause(iOException);
            throw certificateException;
        }
    }

    public Collection engineGenerateCertificates(InputStream inputStream) throws CertificateException {
        LinkedList<X509Certificate> linkedList = new LinkedList<X509Certificate>();
        try {
            while (true) {
                linkedList.add(this.generateCert(inputStream));
            }
        }
        catch (EOFException eOFException) {
        }
        catch (IOException iOException) {
            CertificateException certificateException = new CertificateException(iOException.getMessage());
            certificateException.initCause(iOException);
            throw certificateException;
        }
        return linkedList;
    }

    public CRL engineGenerateCRL(InputStream inputStream) throws CRLException {
        try {
            return this.generateCRL(inputStream);
        }
        catch (IOException iOException) {
            CRLException cRLException = new CRLException(iOException.getMessage());
            cRLException.initCause(iOException);
            throw cRLException;
        }
    }

    public Collection engineGenerateCRLs(InputStream inputStream) throws CRLException {
        LinkedList<X509CRL> linkedList = new LinkedList<X509CRL>();
        try {
            while (true) {
                linkedList.add(this.generateCRL(inputStream));
            }
        }
        catch (EOFException eOFException) {
        }
        catch (IOException iOException) {
            CRLException cRLException = new CRLException(iOException.getMessage());
            cRLException.initCause(iOException);
            throw cRLException;
        }
        return linkedList;
    }

    public CertPath engineGenerateCertPath(List list2) {
        return new X509CertPath(list2);
    }

    public CertPath engineGenerateCertPath(InputStream inputStream) throws CertificateEncodingException {
        return new X509CertPath(inputStream);
    }

    public CertPath engineGenerateCertPath(InputStream inputStream, String string) throws CertificateEncodingException {
        return new X509CertPath(inputStream, string);
    }

    public Iterator engineGetCertPathEncodings() {
        return X509CertPath.ENCODINGS.iterator();
    }

    private X509Certificate generateCert(InputStream inputStream) throws IOException, CertificateException {
        if (inputStream == null) {
            throw new CertificateException("missing input stream");
        }
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream, 8192);
        }
        inputStream.mark(20);
        int n = inputStream.read();
        if (n == -1) {
            throw new EOFException();
        }
        if (n != 48) {
            inputStream.reset();
            CPStringBuilder cPStringBuilder = new CPStringBuilder(80);
            do {
                cPStringBuilder.setLength(0);
                do {
                    if ((n = inputStream.read()) == -1) {
                        throw new EOFException();
                    }
                    if (n == 10 || n == 13) continue;
                    cPStringBuilder.append((char)n);
                } while (n != 10 && n != 13);
            } while (!cPStringBuilder.toString().equals(BEGIN_CERTIFICATE));
            X509Certificate x509Certificate = new X509Certificate(new BufferedInputStream(new Base64InputStream(inputStream), 8192));
            cPStringBuilder.setLength(0);
            cPStringBuilder.append('-');
            do {
                if ((n = inputStream.read()) == -1) {
                    throw new EOFException();
                }
                if (n == 10 || n == 13) continue;
                cPStringBuilder.append((char)n);
            } while (n != 10 && n != 13);
            if (!cPStringBuilder.toString().equals(END_CERTIFICATE)) {
                throw new CertificateException("no end-of-certificate marker");
            }
            return x509Certificate;
        }
        inputStream.reset();
        return new X509Certificate(inputStream);
    }

    private X509CRL generateCRL(InputStream inputStream) throws IOException, CRLException {
        if (inputStream == null) {
            throw new CRLException("missing input stream");
        }
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream, 8192);
        }
        inputStream.mark(20);
        int n = inputStream.read();
        if (n == -1) {
            throw new EOFException();
        }
        if (n != 48) {
            inputStream.reset();
            CPStringBuilder cPStringBuilder = new CPStringBuilder(80);
            do {
                cPStringBuilder.setLength(0);
                do {
                    if ((n = inputStream.read()) == -1) {
                        throw new EOFException();
                    }
                    if (n == 10 || n == 13) continue;
                    cPStringBuilder.append((char)n);
                } while (n != 10 && n != 13);
            } while (!cPStringBuilder.toString().startsWith(BEGIN_X509_CRL));
            X509CRL x509CRL = new X509CRL(new BufferedInputStream(new Base64InputStream(inputStream), 8192));
            cPStringBuilder.setLength(0);
            cPStringBuilder.append('-');
            do {
                if ((n = inputStream.read()) == -1) {
                    throw new EOFException();
                }
                if (n == 10 || n == 13) continue;
                cPStringBuilder.append((char)n);
            } while (n != 10 && n != 13);
            if (!cPStringBuilder.toString().startsWith(END_X509_CRL)) {
                throw new CRLException("no end-of-CRL marker");
            }
            return x509CRL;
        }
        inputStream.reset();
        return new X509CRL(inputStream);
    }
}

