/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CRL;
import java.security.cert.CRLSelector;
import java.security.cert.CertSelector;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertStoreSpi;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.util.Collection;
import java.util.LinkedList;

public final class CollectionCertStoreImpl
extends CertStoreSpi {
    private final Collection store;

    public CollectionCertStoreImpl(CertStoreParameters certStoreParameters) throws InvalidAlgorithmParameterException {
        super(certStoreParameters);
        if (!(certStoreParameters instanceof CollectionCertStoreParameters)) {
            throw new InvalidAlgorithmParameterException("not a CollectionCertStoreParameters object");
        }
        this.store = ((CollectionCertStoreParameters)certStoreParameters).getCollection();
    }

    public Collection engineGetCertificates(CertSelector certSelector) throws CertStoreException {
        LinkedList linkedList = new LinkedList();
        for (Object e : this.store) {
            if (!(e instanceof Certificate) || !certSelector.match((Certificate)e)) continue;
            linkedList.add(e);
        }
        return linkedList;
    }

    public Collection engineGetCRLs(CRLSelector cRLSelector) throws CertStoreException {
        LinkedList linkedList = new LinkedList();
        for (Object e : this.store) {
            if (!(e instanceof CRL) || !cRLSelector.match((CRL)e)) continue;
            linkedList.add(e);
        }
        return linkedList;
    }
}

