/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.key.dss;

import gnu.java.security.OID;
import gnu.java.security.der.BitString;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.der.DERWriter;
import gnu.java.security.key.IKeyPairCodec;
import gnu.java.security.key.dss.DSSPublicKey;
import gnu.java.security.util.DerUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;

public class DSSKeyPairX509Codec
implements IKeyPairCodec {
    private static final OID DSA_ALG_OID = new OID("1.2.840.10040.4.1");

    public int getFormatID() {
        return 2;
    }

    public byte[] encodePublicKey(PublicKey publicKey) {
        byte[] byArray;
        ArrayList<Object> arrayList;
        DERValue dERValue;
        Object object;
        DERValue dERValue2;
        BigInteger bigInteger;
        Object object2;
        Serializable serializable;
        DERValue dERValue3;
        if (!(publicKey instanceof DSSPublicKey)) {
            throw new InvalidParameterException("key");
        }
        DERValue dERValue4 = new DERValue(6, DSA_ALG_OID);
        DSSPublicKey dSSPublicKey = (DSSPublicKey)publicKey;
        if (dSSPublicKey.hasInheritedParameters()) {
            dERValue3 = new DERValue(5, null);
        } else {
            serializable = dSSPublicKey.getParams().getP();
            object2 = dSSPublicKey.getParams().getQ();
            bigInteger = dSSPublicKey.getParams().getG();
            dERValue2 = new DERValue(2, serializable);
            object = new DERValue(2, object2);
            dERValue = new DERValue(2, bigInteger);
            arrayList = new ArrayList<Object>(3);
            arrayList.add(dERValue2);
            arrayList.add(object);
            arrayList.add(dERValue);
            dERValue3 = new DERValue(48, arrayList);
        }
        serializable = new ArrayList(2);
        ((ArrayList)serializable).add(dERValue4);
        ((ArrayList)serializable).add(dERValue3);
        object2 = new DERValue(48, serializable);
        bigInteger = dSSPublicKey.getY();
        dERValue2 = new DERValue(2, bigInteger);
        object = dERValue2.getEncoded();
        dERValue = new DERValue(3, new BitString((byte[])object));
        arrayList = new ArrayList(2);
        arrayList.add(object2);
        arrayList.add(dERValue);
        DERValue dERValue5 = new DERValue(48, arrayList);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            DERWriter.write(byteArrayOutputStream, dERValue5);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            InvalidParameterException invalidParameterException = new InvalidParameterException(iOException.getMessage());
            invalidParameterException.initCause(iOException);
            throw invalidParameterException;
        }
        return byArray;
    }

    public byte[] encodePrivateKey(PrivateKey privateKey) {
        throw new InvalidParameterException("Wrong format for private keys");
    }

    public PublicKey decodePublicKey(byte[] byArray) {
        BigInteger bigInteger;
        if (byArray == null) {
            throw new InvalidParameterException("Input bytes MUST NOT be null");
        }
        BigInteger bigInteger2 = null;
        BigInteger bigInteger3 = null;
        BigInteger bigInteger4 = null;
        DERReader dERReader = new DERReader(byArray);
        try {
            DERValue dERValue = dERReader.read();
            DerUtil.checkIsConstructed(dERValue, "Wrong SubjectPublicKeyInfo field");
            DERValue dERValue2 = dERReader.read();
            DerUtil.checkIsConstructed(dERValue2, "Wrong AlgorithmIdentifier field");
            DERValue dERValue3 = dERReader.read();
            if (!(dERValue3.getValue() instanceof OID)) {
                throw new InvalidParameterException("Wrong Algorithm field");
            }
            OID oID = (OID)dERValue3.getValue();
            if (!oID.equals(DSA_ALG_OID)) {
                throw new InvalidParameterException("Unexpected OID: " + oID);
            }
            DERValue dERValue4 = dERReader.read();
            if (dERValue4.getTag() == 5) {
                dERValue4 = dERReader.read();
            } else if (dERValue4.isConstructed()) {
                dERValue4 = dERReader.read();
                DerUtil.checkIsBigInteger(dERValue4, "Wrong P field");
                bigInteger2 = (BigInteger)dERValue4.getValue();
                dERValue4 = dERReader.read();
                DerUtil.checkIsBigInteger(dERValue4, "Wrong Q field");
                bigInteger4 = (BigInteger)dERValue4.getValue();
                dERValue4 = dERReader.read();
                DerUtil.checkIsBigInteger(dERValue4, "Wrong G field");
                bigInteger3 = (BigInteger)dERValue4.getValue();
                dERValue4 = dERReader.read();
            }
            if (!(dERValue4.getValue() instanceof BitString)) {
                throw new InvalidParameterException("Wrong SubjectPublicKey field");
            }
            byte[] byArray2 = ((BitString)dERValue4.getValue()).toByteArray();
            DERReader dERReader2 = new DERReader(byArray2);
            dERValue4 = dERReader2.read();
            DerUtil.checkIsBigInteger(dERValue4, "Wrong Y field");
            bigInteger = (BigInteger)dERValue4.getValue();
        }
        catch (IOException iOException) {
            InvalidParameterException invalidParameterException = new InvalidParameterException(iOException.getMessage());
            invalidParameterException.initCause(iOException);
            throw invalidParameterException;
        }
        return new DSSPublicKey(2, bigInteger2, bigInteger4, bigInteger3, bigInteger);
    }

    public PrivateKey decodePrivateKey(byte[] byArray) {
        throw new InvalidParameterException("Wrong format for private keys");
    }
}

