/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.key;

import gnu.java.security.key.IKeyPairGenerator;
import gnu.java.security.key.dss.DSSKeyPairGenerator;
import gnu.java.security.key.rsa.RSAKeyPairGenerator;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class KeyPairGeneratorFactory {
    private KeyPairGeneratorFactory() {
    }

    public static IKeyPairGenerator getInstance(String string) {
        if (string == null) {
            return null;
        }
        string = string.trim();
        IKeyPairGenerator iKeyPairGenerator = null;
        if (string.equalsIgnoreCase("dsa") || string.equalsIgnoreCase("dss")) {
            iKeyPairGenerator = new DSSKeyPairGenerator();
        } else if (string.equalsIgnoreCase("rsa")) {
            iKeyPairGenerator = new RSAKeyPairGenerator();
        } else if (string.equalsIgnoreCase("dh")) {
            iKeyPairGenerator = KeyPairGeneratorFactory.makeInstance("gnu.javax.crypto.key.dh.GnuDHKeyPairGenerator");
        } else if (string.equalsIgnoreCase("srp")) {
            iKeyPairGenerator = KeyPairGeneratorFactory.makeInstance("gnu.javax.crypto.key.srp6.SRPKeyPairGenerator");
        }
        return iKeyPairGenerator;
    }

    public static final Set getNames() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("dss");
        hashSet.add("dsa");
        hashSet.add("rsa");
        hashSet.add("dh");
        hashSet.add("srp");
        return Collections.unmodifiableSet(hashSet);
    }

    private static IKeyPairGenerator makeInstance(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            return (IKeyPairGenerator)constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("strong crypto key pair generator not available: " + string, exception);
        }
    }
}

