/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.jce.sig;

import gnu.java.security.key.rsa.GnuRSAPrivateKey;
import gnu.java.security.key.rsa.GnuRSAPublicKey;
import gnu.java.security.key.rsa.RSAKeyPairPKCS8Codec;
import gnu.java.security.key.rsa.RSAKeyPairX509Codec;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class RSAKeyFactory
extends KeyFactorySpi {
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof RSAPublicKeySpec) {
            RSAPublicKeySpec rSAPublicKeySpec = (RSAPublicKeySpec)keySpec;
            BigInteger bigInteger = rSAPublicKeySpec.getModulus();
            BigInteger bigInteger2 = rSAPublicKeySpec.getPublicExponent();
            return new GnuRSAPublicKey(2, bigInteger, bigInteger2);
        }
        if (keySpec instanceof X509EncodedKeySpec) {
            X509EncodedKeySpec x509EncodedKeySpec = (X509EncodedKeySpec)keySpec;
            byte[] byArray = x509EncodedKeySpec.getEncoded();
            try {
                return new RSAKeyPairX509Codec().decodePublicKey(byArray);
            }
            catch (RuntimeException runtimeException) {
                throw new InvalidKeySpecException(runtimeException.getMessage(), runtimeException);
            }
        }
        throw new InvalidKeySpecException("Unsupported (public) key specification");
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof RSAPrivateCrtKeySpec) {
            RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = (RSAPrivateCrtKeySpec)keySpec;
            BigInteger bigInteger = rSAPrivateCrtKeySpec.getModulus();
            BigInteger bigInteger2 = rSAPrivateCrtKeySpec.getPublicExponent();
            BigInteger bigInteger3 = rSAPrivateCrtKeySpec.getPrivateExponent();
            BigInteger bigInteger4 = rSAPrivateCrtKeySpec.getPrimeP();
            BigInteger bigInteger5 = rSAPrivateCrtKeySpec.getPrimeQ();
            BigInteger bigInteger6 = rSAPrivateCrtKeySpec.getPrimeExponentP();
            BigInteger bigInteger7 = rSAPrivateCrtKeySpec.getPrimeExponentQ();
            BigInteger bigInteger8 = rSAPrivateCrtKeySpec.getCrtCoefficient();
            return new GnuRSAPrivateKey(3, bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
        }
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = (PKCS8EncodedKeySpec)keySpec;
            byte[] byArray = pKCS8EncodedKeySpec.getEncoded();
            try {
                return new RSAKeyPairPKCS8Codec().decodePrivateKey(byArray);
            }
            catch (RuntimeException runtimeException) {
                throw new InvalidKeySpecException(runtimeException.getMessage(), runtimeException);
            }
        }
        throw new InvalidKeySpecException("Unsupported (private) key specification");
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (key instanceof RSAPublicKey) {
            if (clazz.isAssignableFrom(RSAPublicKeySpec.class)) {
                RSAPublicKey rSAPublicKey = (RSAPublicKey)key;
                BigInteger bigInteger = rSAPublicKey.getModulus();
                BigInteger bigInteger2 = rSAPublicKey.getPublicExponent();
                return new RSAPublicKeySpec(bigInteger, bigInteger2);
            }
            if (clazz.isAssignableFrom(X509EncodedKeySpec.class)) {
                if (key instanceof GnuRSAPublicKey) {
                    GnuRSAPublicKey gnuRSAPublicKey = (GnuRSAPublicKey)key;
                    byte[] byArray = gnuRSAPublicKey.getEncoded(2);
                    return new X509EncodedKeySpec(byArray);
                }
                if ("X.509".equalsIgnoreCase(key.getFormat())) {
                    byte[] byArray = key.getEncoded();
                    return new X509EncodedKeySpec(byArray);
                }
                throw new InvalidKeySpecException("Wrong key type or unsupported (public) key specification");
            }
            throw new InvalidKeySpecException("Unsupported (public) key specification");
        }
        if (key instanceof RSAPrivateCrtKey && clazz.isAssignableFrom(RSAPrivateCrtKeySpec.class)) {
            RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)key;
            BigInteger bigInteger = rSAPrivateCrtKey.getModulus();
            BigInteger bigInteger3 = rSAPrivateCrtKey.getPublicExponent();
            BigInteger bigInteger4 = rSAPrivateCrtKey.getPrivateExponent();
            BigInteger bigInteger5 = rSAPrivateCrtKey.getPrimeP();
            BigInteger bigInteger6 = rSAPrivateCrtKey.getPrimeQ();
            BigInteger bigInteger7 = rSAPrivateCrtKey.getPrimeExponentP();
            BigInteger bigInteger8 = rSAPrivateCrtKey.getPrimeExponentQ();
            BigInteger bigInteger9 = rSAPrivateCrtKey.getCrtCoefficient();
            return new RSAPrivateCrtKeySpec(bigInteger, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8, bigInteger9);
        }
        if (key instanceof RSAPrivateKey && clazz.isAssignableFrom(RSAPrivateKeySpec.class)) {
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)key;
            BigInteger bigInteger = rSAPrivateKey.getModulus();
            BigInteger bigInteger10 = rSAPrivateKey.getPrivateExponent();
            return new RSAPrivateKeySpec(bigInteger, bigInteger10);
        }
        if (clazz.isAssignableFrom(PKCS8EncodedKeySpec.class)) {
            if (key instanceof GnuRSAPrivateKey) {
                GnuRSAPrivateKey gnuRSAPrivateKey = (GnuRSAPrivateKey)key;
                byte[] byArray = gnuRSAPrivateKey.getEncoded(3);
                return new PKCS8EncodedKeySpec(byArray);
            }
            if ("PKCS#8".equalsIgnoreCase(key.getFormat())) {
                byte[] byArray = key.getEncoded();
                return new PKCS8EncodedKeySpec(byArray);
            }
            throw new InvalidKeySpecException("Wrong key type or unsupported (private) key specification");
        }
        throw new InvalidKeySpecException("Wrong key type or unsupported key specification");
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof GnuRSAPublicKey || key instanceof GnuRSAPrivateKey) {
            return key;
        }
        if (key instanceof RSAPublicKey) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)key;
            BigInteger bigInteger = rSAPublicKey.getModulus();
            BigInteger bigInteger2 = rSAPublicKey.getPublicExponent();
            return new GnuRSAPublicKey(2, bigInteger, bigInteger2);
        }
        if (key instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)key;
            BigInteger bigInteger = rSAPrivateCrtKey.getModulus();
            BigInteger bigInteger3 = rSAPrivateCrtKey.getPublicExponent();
            BigInteger bigInteger4 = rSAPrivateCrtKey.getPrivateExponent();
            BigInteger bigInteger5 = rSAPrivateCrtKey.getPrimeP();
            BigInteger bigInteger6 = rSAPrivateCrtKey.getPrimeQ();
            BigInteger bigInteger7 = rSAPrivateCrtKey.getPrimeExponentP();
            BigInteger bigInteger8 = rSAPrivateCrtKey.getPrimeExponentQ();
            BigInteger bigInteger9 = rSAPrivateCrtKey.getCrtCoefficient();
            return new GnuRSAPrivateKey(3, bigInteger, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8, bigInteger9);
        }
        throw new InvalidKeyException("Unsupported key type");
    }
}

