/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.jce.sig;

import gnu.java.security.key.dss.DSSPrivateKey;
import gnu.java.security.key.dss.DSSPublicKey;
import gnu.java.security.key.rsa.GnuRSAPrivateKey;
import gnu.java.security.key.rsa.GnuRSAPublicKey;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.logging.Logger;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;

public class EncodedKeyFactory
extends KeyFactorySpi {
    private static final Logger log = null;

    private static Object invokeConstructor(String string, Object[] objectArray) throws InvalidKeySpecException {
        Class clazz = EncodedKeyFactory.getConcreteClass(string);
        try {
            Constructor constructor = EncodedKeyFactory.getConcreteCtor(clazz);
            Object t = constructor.newInstance(objectArray);
            return t;
        }
        catch (InstantiationException instantiationException) {
            throw new InvalidKeySpecException(instantiationException.getMessage(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InvalidKeySpecException(illegalAccessException.getMessage(), illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InvalidKeySpecException(invocationTargetException.getMessage(), invocationTargetException);
        }
    }

    private static Class getConcreteClass(String string) throws InvalidKeySpecException {
        try {
            Class<?> clazz = Class.forName(string);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidKeySpecException(classNotFoundException.getMessage(), classNotFoundException);
        }
    }

    private static Constructor getConcreteCtor(Class clazz) throws InvalidKeySpecException {
        try {
            Constructor constructor = clazz.getConstructor(Integer.TYPE, BigInteger.class, BigInteger.class, BigInteger.class, BigInteger.class);
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InvalidKeySpecException(noSuchMethodException.getMessage(), noSuchMethodException);
        }
    }

    private static Object invokeValueOf(String string, byte[] byArray) throws InvalidKeySpecException {
        Class clazz = EncodedKeyFactory.getConcreteClass(string);
        try {
            Method method = EncodedKeyFactory.getValueOfMethod(clazz);
            Object object = method.invoke(null, new Object[]{byArray});
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InvalidKeySpecException(illegalAccessException.getMessage(), illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InvalidKeySpecException(invocationTargetException.getMessage(), invocationTargetException);
        }
    }

    private static Method getValueOfMethod(Class clazz) throws InvalidKeySpecException {
        try {
            Method method = clazz.getMethod("valueOf", byte[].class);
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InvalidKeySpecException(noSuchMethodException.getMessage(), noSuchMethodException);
        }
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        PublicKey publicKey = null;
        if (keySpec instanceof DSAPublicKeySpec) {
            publicKey = this.decodeDSSPublicKey((DSAPublicKeySpec)keySpec);
        } else if (keySpec instanceof RSAPublicKeySpec) {
            publicKey = this.decodeRSAPublicKey((RSAPublicKeySpec)keySpec);
        } else if (keySpec instanceof DHPublicKeySpec) {
            publicKey = this.decodeDHPublicKey((DHPublicKeySpec)keySpec);
        } else {
            if (!(keySpec instanceof X509EncodedKeySpec)) {
                throw new InvalidKeySpecException("Unsupported key specification");
            }
            byte[] byArray = ((X509EncodedKeySpec)keySpec).getEncoded();
            boolean bl = false;
            try {
                publicKey = DSSPublicKey.valueOf(byArray);
                bl = true;
            }
            catch (InvalidParameterException invalidParameterException) {
                // empty catch block
            }
            if (!bl) {
                try {
                    publicKey = GnuRSAPublicKey.valueOf(byArray);
                    bl = true;
                }
                catch (InvalidParameterException invalidParameterException) {
                    // empty catch block
                }
            }
            if (!bl) {
                publicKey = this.decodeDHPublicKey(byArray);
            }
        }
        return publicKey;
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        PrivateKey privateKey = null;
        if (keySpec instanceof DSAPrivateKeySpec) {
            privateKey = this.decodeDSSPrivateKey((DSAPrivateKeySpec)keySpec);
        } else if (keySpec instanceof RSAPrivateCrtKeySpec) {
            privateKey = this.decodeRSAPrivateKey((RSAPrivateCrtKeySpec)keySpec);
        } else if (keySpec instanceof DHPrivateKeySpec) {
            privateKey = this.decodeDHPrivateKey((DHPrivateKeySpec)keySpec);
        } else {
            if (!(keySpec instanceof PKCS8EncodedKeySpec)) {
                throw new InvalidKeySpecException("Unsupported key specification");
            }
            byte[] byArray = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
            boolean bl = false;
            try {
                privateKey = DSSPrivateKey.valueOf(byArray);
                bl = true;
            }
            catch (InvalidParameterException invalidParameterException) {
                // empty catch block
            }
            if (!bl) {
                try {
                    privateKey = GnuRSAPrivateKey.valueOf(byArray);
                    bl = true;
                }
                catch (InvalidParameterException invalidParameterException) {
                    // empty catch block
                }
            }
            if (!bl) {
                privateKey = this.decodeDHPrivateKey(byArray);
            }
        }
        return privateKey;
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (key instanceof PublicKey && "X.509".equalsIgnoreCase(key.getFormat()) && clazz.isAssignableFrom(X509EncodedKeySpec.class)) {
            return new X509EncodedKeySpec(key.getEncoded());
        }
        if (key instanceof PrivateKey && "PKCS#8".equalsIgnoreCase(key.getFormat()) && clazz.isAssignableFrom(PKCS8EncodedKeySpec.class)) {
            return new PKCS8EncodedKeySpec(key.getEncoded());
        }
        throw new InvalidKeySpecException("Unsupported format or invalid key spec class");
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        throw new InvalidKeyException("Key translation not supported");
    }

    private DSSPublicKey decodeDSSPublicKey(DSAPublicKeySpec dSAPublicKeySpec) {
        BigInteger bigInteger = dSAPublicKeySpec.getP();
        BigInteger bigInteger2 = dSAPublicKeySpec.getQ();
        BigInteger bigInteger3 = dSAPublicKeySpec.getG();
        BigInteger bigInteger4 = dSAPublicKeySpec.getY();
        return new DSSPublicKey(2, bigInteger, bigInteger2, bigInteger3, bigInteger4);
    }

    private GnuRSAPublicKey decodeRSAPublicKey(RSAPublicKeySpec rSAPublicKeySpec) {
        BigInteger bigInteger = rSAPublicKeySpec.getModulus();
        BigInteger bigInteger2 = rSAPublicKeySpec.getPublicExponent();
        return new GnuRSAPublicKey(2, bigInteger, bigInteger2);
    }

    private DHPublicKey decodeDHPublicKey(DHPublicKeySpec dHPublicKeySpec) throws InvalidKeySpecException {
        BigInteger bigInteger = dHPublicKeySpec.getP();
        BigInteger bigInteger2 = dHPublicKeySpec.getG();
        BigInteger bigInteger3 = dHPublicKeySpec.getY();
        Object[] objectArray = new Object[]{2, null, bigInteger, bigInteger2, bigInteger3};
        Object object = EncodedKeyFactory.invokeConstructor("gnu.javax.crypto.key.dh.GnuDHPublicKey", objectArray);
        return (DHPublicKey)object;
    }

    private DHPublicKey decodeDHPublicKey(byte[] byArray) throws InvalidKeySpecException {
        Object object = EncodedKeyFactory.invokeValueOf("gnu.javax.crypto.key.dh.GnuDHPublicKey", byArray);
        return (DHPublicKey)object;
    }

    private PrivateKey decodeDSSPrivateKey(DSAPrivateKeySpec dSAPrivateKeySpec) {
        BigInteger bigInteger = dSAPrivateKeySpec.getP();
        BigInteger bigInteger2 = dSAPrivateKeySpec.getQ();
        BigInteger bigInteger3 = dSAPrivateKeySpec.getG();
        BigInteger bigInteger4 = dSAPrivateKeySpec.getX();
        return new DSSPrivateKey(3, bigInteger, bigInteger2, bigInteger3, bigInteger4);
    }

    private PrivateKey decodeRSAPrivateKey(RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec) {
        BigInteger bigInteger = rSAPrivateCrtKeySpec.getModulus();
        BigInteger bigInteger2 = rSAPrivateCrtKeySpec.getPublicExponent();
        BigInteger bigInteger3 = rSAPrivateCrtKeySpec.getPrivateExponent();
        BigInteger bigInteger4 = rSAPrivateCrtKeySpec.getPrimeP();
        BigInteger bigInteger5 = rSAPrivateCrtKeySpec.getPrimeQ();
        BigInteger bigInteger6 = rSAPrivateCrtKeySpec.getPrimeExponentP();
        BigInteger bigInteger7 = rSAPrivateCrtKeySpec.getPrimeExponentQ();
        BigInteger bigInteger8 = rSAPrivateCrtKeySpec.getCrtCoefficient();
        return new GnuRSAPrivateKey(3, bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
    }

    private DHPrivateKey decodeDHPrivateKey(DHPrivateKeySpec dHPrivateKeySpec) throws InvalidKeySpecException {
        BigInteger bigInteger = dHPrivateKeySpec.getP();
        BigInteger bigInteger2 = dHPrivateKeySpec.getG();
        BigInteger bigInteger3 = dHPrivateKeySpec.getX();
        Object[] objectArray = new Object[]{3, null, bigInteger, bigInteger2, bigInteger3};
        Object object = EncodedKeyFactory.invokeConstructor("gnu.javax.crypto.key.dh.GnuDHPrivateKey", objectArray);
        return (DHPrivateKey)object;
    }

    private DHPrivateKey decodeDHPrivateKey(byte[] byArray) throws InvalidKeySpecException {
        Object object = EncodedKeyFactory.invokeValueOf("gnu.javax.crypto.key.dh.GnuDHPrivateKey", byArray);
        return (DHPrivateKey)object;
    }
}

