/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.hash;

import gnu.java.security.hash.BaseHash;
import gnu.java.security.util.Util;

public class MD2
extends BaseHash {
    private static final int DIGEST_LENGTH = 16;
    private static final int BLOCK_LENGTH = 16;
    private static final byte[] PI = new byte[]{41, 46, 67, -55, -94, -40, 124, 1, 61, 54, 84, -95, -20, -16, 6, 19, 98, -89, 5, -13, -64, -57, 115, -116, -104, -109, 43, -39, -68, 76, -126, -54, 30, -101, 87, 60, -3, -44, -32, 22, 103, 66, 111, 24, -118, 23, -27, 18, -66, 78, -60, -42, -38, -98, -34, 73, -96, -5, -11, -114, -69, 47, -18, 122, -87, 104, 121, -111, 21, -78, 7, 63, -108, -62, 16, -119, 11, 34, 95, 33, -128, 127, 93, -102, 90, -112, 50, 39, 53, 62, -52, -25, -65, -9, -105, 3, -1, 25, 48, -77, 72, -91, -75, -47, -41, 94, -110, 42, -84, 86, -86, -58, 79, -72, 56, -46, -106, -92, 125, -74, 118, -4, 107, -30, -100, 116, 4, -15, 69, -99, 112, 89, 100, 113, -121, 32, -122, 91, -49, 101, -26, 45, -88, 2, 27, 96, 37, -83, -82, -80, -71, -10, 28, 70, 97, 105, 52, 64, 126, 15, 85, 71, -93, 35, -35, 81, -81, 58, -61, 92, -7, -50, -70, -59, -22, 38, 44, 83, 13, 110, -123, 40, -124, 9, -45, -33, -51, -12, 65, -127, 77, 82, 106, -36, 55, -56, 108, -63, -85, -6, 36, -31, 123, 8, 12, -67, -79, 74, 120, -120, -107, -117, -29, 99, -24, 109, -23, -53, -43, -2, 59, 0, 29, 57, -14, -17, -73, 14, 102, 88, -48, -28, -90, 119, 114, -8, -21, 117, 75, 10, 49, 68, 80, -76, -113, -19, 31, 26, -37, -103, -115, 51, -97, 17, -125, 20};
    private static final String DIGEST0 = "8350E5A3E24C153DF2275C9F80692773";
    private static Boolean valid;
    private byte[] checksum;
    private byte[] work;

    public MD2() {
        super("md2", 16, 16);
    }

    private MD2(MD2 mD2) {
        this();
        this.count = mD2.count;
        this.buffer = (byte[])mD2.buffer.clone();
        this.checksum = (byte[])mD2.checksum.clone();
        this.work = (byte[])mD2.work.clone();
    }

    public Object clone() {
        return new MD2(this);
    }

    protected byte[] getResult() {
        byte[] byArray = new byte[16];
        this.encryptBlock(this.checksum, 0);
        for (int i = 0; i < 16; ++i) {
            byArray[i] = this.work[i];
        }
        return byArray;
    }

    protected void resetContext() {
        this.checksum = new byte[16];
        this.work = new byte[48];
    }

    public boolean selfTest() {
        if (valid == null) {
            String string = Util.toString(new MD2().digest());
            valid = DIGEST0.equals(string);
        }
        return valid;
    }

    protected byte[] padBuffer() {
        int n = 16 - (int)(this.count % 16L);
        if (n == 0) {
            n = 16;
        }
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)n;
        }
        return byArray;
    }

    protected void transform(byte[] byArray, int n) {
        this.updateCheckSumAndEncryptBlock(byArray, n);
    }

    private void encryptBlock(byte[] byArray, int n) {
        int n2;
        int n3;
        for (n3 = 0; n3 < 16; ++n3) {
            this.work[16 + n3] = n2 = byArray[n + n3];
            this.work[32 + n3] = (byte)(this.work[n3] ^ n2);
        }
        n3 = 0;
        for (n2 = 0; n2 < 18; ++n2) {
            for (int i = 0; i < 48; ++i) {
                this.work[i] = n3 = (int)((byte)(this.work[i] ^ PI[n3 & 0xFF]));
            }
            n3 = (byte)(n3 + n2);
        }
    }

    private void updateCheckSumAndEncryptBlock(byte[] byArray, int n) {
        int n2;
        int n3;
        byte by = this.checksum[15];
        for (n3 = 0; n3 < 16; ++n3) {
            this.work[16 + n3] = n2 = byArray[n + n3];
            this.work[32 + n3] = (byte)(this.work[n3] ^ n2);
            this.checksum[n3] = by = (byte)(this.checksum[n3] ^ PI[(n2 ^ by) & 0xFF]);
        }
        n3 = 0;
        for (n2 = 0; n2 < 18; ++n2) {
            for (int i = 0; i < 48; ++i) {
                this.work[i] = n3 = (int)((byte)(this.work[i] ^ PI[n3 & 0xFF]));
            }
            n3 = (byte)(n3 + n2);
        }
    }
}

