/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.der;

import gnu.java.lang.CPStringBuilder;
import java.math.BigInteger;
import java.util.Arrays;

public class BitString
implements Cloneable,
Comparable {
    private final byte[] bytes;
    private transient byte[] externBytes;
    private final int ignoredBits;
    private transient boolean[] boolVal;

    public BitString(byte[] byArray, int n, boolean bl) {
        this(byArray, 0, byArray.length, n, bl);
    }

    public BitString(byte[] byArray, int n, int n2, int n3, boolean bl) {
        if (n3 < 0 || n3 > 7) {
            throw new IllegalArgumentException();
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (bl && n3 > 0) {
            this.externBytes = new byte[n2];
            System.arraycopy(byArray, n, this.externBytes, 0, n2);
            this.bytes = new BigInteger(this.externBytes).shiftLeft(n3).toByteArray();
        } else {
            this.bytes = new byte[n2];
            System.arraycopy(byArray, n, this.bytes, 0, n2);
        }
        this.ignoredBits = n3;
    }

    public BitString(byte[] byArray, int n, int n2, int n3) {
        this(byArray, n, n2, n3, false);
    }

    public BitString(byte[] byArray, int n) {
        this(byArray, 0, byArray.length, n, false);
    }

    public BitString(byte[] byArray, int n, int n2) {
        this(byArray, n, n2, 0, false);
    }

    public BitString(byte[] byArray) {
        this(byArray, 0, byArray.length, 0, false);
    }

    public byte[] toByteArray() {
        if (this.ignoredBits == 0) {
            return (byte[])this.bytes.clone();
        }
        if (this.externBytes == null) {
            this.externBytes = new BigInteger(this.bytes).shiftRight(this.ignoredBits).toByteArray();
        }
        return (byte[])this.externBytes.clone();
    }

    public byte[] getShiftedByteArray() {
        return (byte[])this.bytes.clone();
    }

    public int getIgnoredBits() {
        return this.ignoredBits;
    }

    public int size() {
        return (this.bytes.length << 3) - this.ignoredBits;
    }

    public boolean[] toBooleanArray() {
        if (this.boolVal == null) {
            this.boolVal = new boolean[this.size()];
            int n = 7;
            int n2 = 0;
            for (int i = 0; i < this.boolVal.length; ++i) {
                boolean bl = this.boolVal[i] = (this.bytes[n2] & 1 << n--) != 0;
                if (n >= 0) continue;
                n = 7;
                ++n2;
            }
        }
        return (boolean[])this.boolVal.clone();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.getMessage());
        }
    }

    public int compareTo(Object object) {
        BitString bitString = (BitString)object;
        if (this.equals(bitString)) {
            return 0;
        }
        if (this.bytes.length != bitString.bytes.length) {
            return this.bytes.length < bitString.bytes.length ? -1 : 1;
        }
        if (this.ignoredBits != bitString.ignoredBits) {
            return this.ignoredBits < bitString.ignoredBits ? -1 : 1;
        }
        for (int i = 0; i < this.bytes.length; ++i) {
            if (this.bytes[i] == bitString.bytes[i]) continue;
            return this.bytes[i] < bitString.bytes[i] ? -1 : 1;
        }
        return 0;
    }

    public int hashCode() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.bytes.length - 1; ++n) {
            n2 = n2 * 31 + this.bytes[n];
        }
        if (this.bytes.length > 0) {
            n = this.bytes[this.bytes.length - 1] & ~((1 << this.ignoredBits) - 1);
            n2 = n2 * 31 + n;
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BitString)) {
            return false;
        }
        BitString bitString = (BitString)object;
        if (this.bytes == bitString.bytes && this.ignoredBits == bitString.ignoredBits) {
            return true;
        }
        if (this.ignoredBits == bitString.ignoredBits) {
            return Arrays.equals(this.bytes, bitString.bytes);
        }
        return false;
    }

    public String toString() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        int n = 7;
        int n2 = 0;
        for (int i = 0; i < this.size(); ++i) {
            cPStringBuilder.append((this.bytes[n2] & 1 << n) != 0 ? "1" : "0");
            if (--n >= 0) continue;
            n = 7;
            ++n2;
        }
        return cPStringBuilder.toString();
    }
}

