/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import gnu.java.rmi.server.RMIHashes;
import gnu.java.rmi.server.RMIObjectInputStream;
import gnu.java.rmi.server.RMIVoidValue;
import gnu.java.rmi.server.UnicastConnection;
import gnu.java.rmi.server.UnicastConnectionManager;
import gnu.java.rmi.server.UnicastRef;
import gnu.java.rmi.server.UnicastRemoteCall;
import gnu.java.rmi.server.UnicastRemoteStub;
import gnu.java.rmi.server.UnicastServer;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ObjID;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteObjectInvocationHandler;
import java.rmi.server.RemoteRef;
import java.rmi.server.RemoteServer;
import java.rmi.server.RemoteStub;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.Skeleton;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;

public class UnicastServerRef
extends UnicastRef {
    private static final long serialVersionUID = -5585608108300801246L;
    private static final Class[] stubprototype = new Class[]{RemoteRef.class};
    Remote myself;
    protected Skeleton skel;
    protected Remote stub;
    protected Hashtable methods = new Hashtable();

    UnicastServerRef() {
    }

    public UnicastServerRef(ObjID objID, int n, RMIServerSocketFactory rMIServerSocketFactory) throws RemoteException {
        super(objID);
        this.manager = UnicastConnectionManager.getInstance(n, rMIServerSocketFactory);
    }

    public Remote exportObject(Remote remote) throws RemoteException {
        if (this.myself == null) {
            Class<? extends Object> clazz;
            Class clazz2;
            this.myself = remote;
            this.manager.serverobj = remote;
            ClassLoader classLoader = remote.getClass().getClassLoader();
            String string = classLoader == null ? "false" : System.getProperty("java.rmi.server.ignoreStubClasses", "false");
            if (!string.equals("true") && (clazz2 = this.findStubSkelClass(clazz = remote.getClass())) != null) {
                this.stub = (RemoteStub)this.getHelperClass(clazz2, "_Stub");
                this.skel = (Skeleton)this.getHelperClass(clazz2, "_Skel");
            }
            if (this.stub == null) {
                this.stub = this.createProxyStub(remote.getClass(), this);
            }
            this.buildMethodHash(remote.getClass(), true);
            UnicastServer.exportObject(this);
        }
        return this.stub;
    }

    public Remote getStub() {
        return this.stub;
    }

    public boolean unexportObject(Remote remote, boolean bl) {
        this.buildMethodHash(remote.getClass(), false);
        return UnicastServer.unexportObject(this, bl);
    }

    protected Class findStubSkelClass(Class clazz) {
        Class clazz2 = clazz;
        while (true) {
            Object object;
            try {
                String string = clazz2.getName() + "_Stub";
                object = clazz2.getClassLoader();
                Class<?> clazz3 = object == null ? Class.forName(string) : ((ClassLoader)object).loadClass(string);
                return clazz2;
            }
            catch (ClassNotFoundException classNotFoundException) {
                object = clazz2.getSuperclass();
                if (object == null || object == UnicastRemoteObject.class) {
                    return null;
                }
                clazz2 = object;
                continue;
            }
            break;
        }
    }

    protected Object getHelperClass(Class clazz, String string) {
        try {
            Class<?> clazz2;
            String string2 = clazz.getName();
            ClassLoader classLoader = clazz.getClassLoader();
            Class<?> clazz3 = clazz2 = classLoader == null ? Class.forName(string2 + string) : classLoader.loadClass(string2 + string);
            if (string.equals("_Stub")) {
                try {
                    Constructor<?> constructor = clazz2.getConstructor(stubprototype);
                    return constructor.newInstance(this);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
                RemoteStub remoteStub = (RemoteStub)clazz2.newInstance();
                UnicastRemoteStub.setStubRef(remoteStub, this);
                return remoteStub;
            }
            return clazz2.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    public String getClientHost() throws ServerNotActiveException {
        return RemoteServer.getClientHost();
    }

    protected void buildMethodHash(Class clazz, boolean bl) {
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (methodArray[i].getDeclaringClass().getName().startsWith("java.")) continue;
            long l = RMIHashes.getMethodHash(methodArray[i]);
            if (bl) {
                this.methods.put(new Long(l), methodArray[i]);
                continue;
            }
            this.methods.remove(new Long(l));
        }
    }

    Class getMethodReturnType(int n, long l) throws Exception {
        if (n == -1) {
            Method method = (Method)this.methods.get(new Long(l));
            return method.getReturnType();
        }
        return null;
    }

    public Object incomingMessageCall(UnicastConnection unicastConnection, int n, long l) throws Exception {
        if (n == -1) {
            Method method = (Method)this.methods.get(new Long(l));
            if (method == null) {
                throw new NoSuchMethodException(this.myself.getClass().getName() + " hash " + l);
            }
            ObjectInputStream objectInputStream = unicastConnection.getObjectInputStream();
            int n2 = method.getParameterTypes().length;
            Object[] objectArray = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                try {
                    objectArray[i] = ((RMIObjectInputStream)objectInputStream).readValue(method.getParameterTypes()[i]);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw exception;
                }
            }
            Object object = null;
            try {
                object = method.invoke(this.myself, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw new Error("The remote method threw a java.lang.Throwable that is neither java.lang.Exception nor java.lang.Error.", invocationTargetException);
            }
            return object;
        }
        if (this.skel == null) {
            throw new NoSuchMethodException("JDK 1.1 call - Skeleton required");
        }
        UnicastRemoteCall unicastRemoteCall = new UnicastRemoteCall(unicastConnection);
        this.skel.dispatch(this.myself, unicastRemoteCall, n, l);
        if (!unicastRemoteCall.isReturnValue()) {
            return RMIVoidValue.INSTANCE;
        }
        return unicastRemoteCall.returnValue();
    }

    Remote createProxyStub(Class clazz, RemoteRef remoteRef) {
        Class<?>[] classArray;
        HashSet hashSet = new HashSet();
        for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            classArray = clazz2.getInterfaces();
            for (int i = 0; i < classArray.length; ++i) {
                if (!Remote.class.isAssignableFrom(classArray[i])) continue;
                hashSet.add(classArray[i]);
            }
        }
        classArray = new Class[hashSet.size()];
        Iterator iterator = hashSet.iterator();
        for (int i = 0; i < classArray.length; ++i) {
            classArray[i] = (Class)iterator.next();
        }
        RemoteObjectInvocationHandler remoteObjectInvocationHandler = new RemoteObjectInvocationHandler(remoteRef);
        Object object = Proxy.newProxyInstance(clazz.getClassLoader(), classArray, remoteObjectInvocationHandler);
        return (Remote)object;
    }
}

