/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import gnu.java.lang.CPStringBuilder;
import gnu.java.lang.reflect.TypeSignature;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.lang.reflect.Method;
import java.security.MessageDigest;

public class RMIHashes {
    public static long getMethodHash(Method method) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            CPStringBuilder cPStringBuilder = new CPStringBuilder();
            cPStringBuilder.append(method.getName());
            cPStringBuilder.append('(');
            Class<?>[] classArray = method.getParameterTypes();
            for (int i = 0; i < classArray.length; ++i) {
                cPStringBuilder.append(TypeSignature.getEncodingOfClass(classArray[i]));
            }
            cPStringBuilder.append(')');
            Class<?> clazz = method.getReturnType();
            if (clazz != Void.TYPE) {
                cPStringBuilder.append(TypeSignature.getEncodingOfClass(clazz));
            } else {
                cPStringBuilder.append('V');
            }
            dataOutputStream.writeUTF(cPStringBuilder.toString());
            dataOutputStream.flush();
            dataOutputStream.close();
            messageDigest.update(byteArrayOutputStream.toByteArray());
            byte[] byArray = messageDigest.digest();
            long l = 0L;
            int n = byArray.length < 8 ? byArray.length : 8;
            for (int i = 0; i < n; ++i) {
                l += (long)(byArray[i] & 0xFF) << 8 * i;
            }
            return l;
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    public static long getInterfaceHash(Class clazz) {
        return clazz.hashCode();
    }
}

