/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import gnu.java.rmi.server.UnicastConnection;
import gnu.java.rmi.server.UnicastServer;
import gnu.java.rmi.server.UnicastServerRef;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationID;
import java.rmi.server.ObjID;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteStub;
import java.rmi.server.Skeleton;

public class ActivatableServerRef
extends UnicastServerRef {
    private static final long serialVersionUID = 1L;
    public ActivationID actId;

    public ActivatableServerRef() {
    }

    public ActivatableServerRef(ObjID objID, ActivationID activationID, int n, RMIServerSocketFactory rMIServerSocketFactory) throws RemoteException {
        super(objID, n, rMIServerSocketFactory);
        this.actId = activationID;
        UnicastServer.exportActivatableObject(this);
    }

    public void inactivate() {
        this.manager.stopServer();
    }

    protected void activate() throws RemoteException {
        try {
            Remote remote = this.actId.activate(false);
            this.exportObject(remote);
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            RemoteException remoteException = new RemoteException("Activation failed.");
            remoteException.detail = exception;
            throw remoteException;
        }
    }

    public Object incomingMessageCall(UnicastConnection unicastConnection, int n, long l) throws Exception {
        if (this.myself == null) {
            this.activate();
        }
        return super.incomingMessageCall(unicastConnection, n, l);
    }

    public Remote exportObject(Remote remote) throws RemoteException {
        Remote remote2 = super.exportObject(remote);
        UnicastServer.registerActivatable(this);
        return remote2;
    }

    public Remote exportClass(Class clazz) throws RemoteException {
        Class clazz2;
        Class clazz3;
        if (!Remote.class.isAssignableFrom(clazz)) {
            throw new InternalError(clazz.getName() + " must implement Remote");
        }
        ClassLoader classLoader = clazz.getClassLoader();
        String string = classLoader == null ? "false" : System.getProperty("java.rmi.server.ignoreStubClasses", "false");
        if (!string.equals("true") && (clazz3 = this.findStubSkelClass(clazz2 = clazz)) != null) {
            this.stub = (RemoteStub)this.getHelperClass(clazz3, "_Stub");
            this.skel = (Skeleton)this.getHelperClass(clazz3, "_Skel");
        }
        if (this.stub == null) {
            this.stub = this.createProxyStub(clazz, this);
        }
        this.buildMethodHash(clazz, true);
        UnicastServer.registerActivatable(this);
        return this.stub;
    }

    public String getRefClass(ObjectOutput objectOutput) {
        return "ActivatableRef";
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.actId = (ActivationID)objectInput.readObject();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.actId);
    }
}

