/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.registry;

import gnu.java.rmi.server.UnicastServerRef;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ObjID;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Hashtable;

public class RegistryImpl
extends UnicastRemoteObject
implements Registry {
    private Hashtable bindings = new Hashtable();

    public RegistryImpl(int n) throws RemoteException {
        this(n, RMISocketFactory.getSocketFactory(), RMISocketFactory.getSocketFactory());
    }

    public RegistryImpl(int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) throws RemoteException {
        super(new UnicastServerRef(new ObjID(0), n, rMIServerSocketFactory));
    }

    public Remote lookup(String string) throws RemoteException, NotBoundException, AccessException {
        Object v = this.bindings.get(string);
        if (v == null) {
            throw new NotBoundException(string);
        }
        return (Remote)v;
    }

    public void bind(String string, Remote remote) throws RemoteException, AlreadyBoundException, AccessException {
        if (this.bindings.containsKey(string)) {
            throw new AlreadyBoundException(string);
        }
        this.bindings.put(string, remote);
    }

    public void unbind(String string) throws RemoteException, NotBoundException, AccessException {
        Object v = this.bindings.remove(string);
        if (v == null) {
            throw new NotBoundException(string);
        }
    }

    public void rebind(String string, Remote remote) throws RemoteException, AccessException {
        this.bindings.put(string, remote);
    }

    public String[] list() throws RemoteException, AccessException {
        int n = this.bindings.size();
        String[] stringArray = new String[n];
        Enumeration enumeration = this.bindings.keys();
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public static void version() {
        System.out.println("rmiregistry (" + System.getProperty("java.vm.name") + ") " + System.getProperty("java.vm.version"));
        System.out.println("Copyright 2006 Free Software Foundation, Inc.");
        System.out.println("This is free software; see the source for copying conditions.  There is NO");
        System.out.println("warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.");
        System.exit(0);
    }

    public static void help() {
        System.out.println("Usage: rmiregistry [OPTION | PORT]\n\n    --help                Print this help, then exit\n    --version             Print version number, then exit\n");
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        int n = 1099;
        if (stringArray.length > 0) {
            if (stringArray[0].equals("--version")) {
                RegistryImpl.version();
            } else if (stringArray[0].equals("--help")) {
                RegistryImpl.help();
            }
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Bad port number - using default");
            }
        }
        try {
            Registry registry = LocateRegistry.createRegistry(n);
        }
        catch (RemoteException remoteException) {
            System.err.println("Registry failed");
        }
    }
}

