/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.dgc;

import gnu.java.rmi.server.UnicastRef;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.rmi.dgc.Lease;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;

public class LeaseRenewingTask {
    public static long REQUEST_LEASE_DURATION = 60000L;
    LinkedList ref = new LinkedList();
    Lease lease = new Lease(null, REQUEST_LEASE_DURATION);
    static Timer timer = new Timer(true);
    static WeakHashMap existingTasks = new WeakHashMap();

    public LeaseRenewingTask(UnicastRef unicastRef) {
        this.lease = this.notifyDGC(unicastRef);
        if (this.lease != null) {
            this.schedule(this.lease);
            this.ref.add(new WeakReference<UnicastRef>(unicastRef));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scheduleLeases(UnicastRef unicastRef) {
        if (unicastRef == null) {
            return;
        }
        try {
            WeakHashMap weakHashMap = existingTasks;
            synchronized (weakHashMap) {
                LeaseRenewingTask leaseRenewingTask = (LeaseRenewingTask)existingTasks.get(unicastRef);
                if (leaseRenewingTask != null) {
                    LinkedList linkedList = leaseRenewingTask.ref;
                    synchronized (linkedList) {
                        leaseRenewingTask.ref.add(new WeakReference<UnicastRef>(unicastRef));
                    }
                } else {
                    existingTasks.put(unicastRef, new LeaseRenewingTask(unicastRef));
                }
            }
        }
        catch (Exception exception) {
            InternalError internalError = new InternalError("Lease for " + unicastRef);
            internalError.initCause(exception);
            throw internalError;
        }
    }

    public void schedule(Lease lease) {
        long l = lease.getValue();
        long l2 = l * 90L / 100L;
        if (l2 == 0L) {
            l2 = l;
        }
        timer.schedule((TimerTask)new LeaseTimerTask(), l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renew() {
        Object var1_1 = null;
        Serializable serializable = this.ref;
        synchronized (serializable) {
            Iterator iterator = this.ref.iterator();
            while (iterator.hasNext() && var1_1 == null) {
                WeakReference weakReference = (WeakReference)iterator.next();
                var1_1 = weakReference.get();
                if (var1_1 != null) continue;
                iterator.remove();
            }
        }
        if (var1_1 != null && (serializable = this.notifyDGC(var1_1)) != null) {
            this.schedule((Lease)serializable);
        }
    }

    public Lease notifyDGC(UnicastRef unicastRef) {
        try {
            return unicastRef.notifyDGC(this.lease);
        }
        catch (Exception exception) {
            return null;
        }
    }

    class LeaseTimerTask
    extends TimerTask {
        LeaseTimerTask() {
        }

        public void run() {
            LeaseRenewingTask.this.renew();
        }
    }
}

