/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset.iconv;

import gnu.classpath.Pointer;
import gnu.java.nio.charset.iconv.IconvMetaData;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

final class IconvEncoder
extends CharsetEncoder {
    private Pointer data;
    private int inremaining;
    private int outremaining;

    private native void openIconv(String var1);

    private native int encode(char[] var1, byte[] var2, int var3, int var4, int var5, int var6);

    private native void closeIconv();

    IconvEncoder(Charset charset, IconvMetaData iconvMetaData) {
        super(charset, iconvMetaData.averageBytesPerChar(), iconvMetaData.maxBytesPerChar());
        this.openIconv(iconvMetaData.iconvName());
    }

    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n;
        char[] cArray;
        int n2 = charBuffer.position();
        int n3 = byteBuffer.position();
        int n4 = charBuffer.remaining();
        int n5 = byteBuffer.remaining();
        if (charBuffer.hasArray()) {
            cArray = charBuffer.array();
        } else {
            cArray = new char[n4];
            charBuffer.get(cArray);
        }
        if (byteBuffer.hasArray()) {
            n = this.encode(cArray, byteBuffer.array(), n2, n4, n3, n5);
            byteBuffer.position(n3 + (n5 - this.outremaining));
        } else {
            byte[] byArray = new byte[n5];
            n = this.encode(cArray, byArray, n2, n4, n3, n5);
            byteBuffer.put(byArray, 0, n5 - this.outremaining);
        }
        charBuffer.position(n2 + (n4 - this.inremaining));
        if (n == 1) {
            return CoderResult.malformedForLength(1);
        }
        if (charBuffer.remaining() == 0) {
            return CoderResult.UNDERFLOW;
        }
        return CoderResult.OVERFLOW;
    }

    protected void finalize() {
        this.closeIconv();
    }
}

