/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset.iconv;

import gnu.classpath.Pointer;
import gnu.java.nio.charset.iconv.IconvMetaData;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

final class IconvDecoder
extends CharsetDecoder {
    private Pointer data;
    private int inremaining;
    private int outremaining;

    IconvDecoder(Charset charset, IconvMetaData iconvMetaData) {
        super(charset, iconvMetaData.averageCharsPerByte(), iconvMetaData.maxCharsPerByte());
        this.openIconv(iconvMetaData.iconvName());
    }

    private native void openIconv(String var1);

    private native int decode(byte[] var1, char[] var2, int var3, int var4, int var5, int var6);

    private native void closeIconv();

    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n;
        byte[] byArray;
        int n2 = byteBuffer.remaining();
        int n3 = byteBuffer.position();
        int n4 = charBuffer.position();
        int n5 = charBuffer.remaining();
        if (byteBuffer.hasArray()) {
            byArray = byteBuffer.array();
        } else {
            byArray = new byte[n2];
            byteBuffer.get(byArray);
        }
        if (charBuffer.hasArray()) {
            n = this.decode(byArray, charBuffer.array(), n3, n2, n4, n5);
            charBuffer.position(n4 + (n5 - this.outremaining));
        } else {
            char[] cArray = new char[n5];
            n = this.decode(byArray, cArray, n3, n2, n4, n5);
            charBuffer.put(cArray, 0, n5 - this.outremaining);
        }
        byteBuffer.position(n3 + (n2 - this.inremaining));
        if (n == 1) {
            return CoderResult.malformedForLength(1);
        }
        if (byteBuffer.remaining() == 0) {
            return CoderResult.UNDERFLOW;
        }
        return CoderResult.OVERFLOW;
    }

    protected void finalize() {
        this.closeIconv();
    }
}

