/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

final class UTF_16Encoder
extends CharsetEncoder {
    static final int BIG_ENDIAN = 0;
    static final int LITTLE_ENDIAN = 1;
    private static final char BYTE_ORDER_MARK = '\ufeff';
    private final ByteOrder byteOrder;
    private final boolean useByteOrderMark;
    private boolean needsByteOrderMark;

    UTF_16Encoder(Charset charset, int n, boolean bl) {
        byte[] byArray;
        float f = bl ? 4.0f : 2.0f;
        if (n == 0) {
            byte[] byArray2 = new byte[2];
            byArray2[0] = -1;
            byArray = byArray2;
            byArray2[1] = -3;
        } else {
            byte[] byArray3 = new byte[2];
            byArray3[0] = -3;
            byArray = byArray3;
            byArray3[1] = -1;
        }
        super(charset, 2.0f, f, byArray);
        this.byteOrder = n == 0 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        this.useByteOrderMark = bl;
        this.needsByteOrderMark = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        CoderResult coderResult;
        int n;
        block15: {
            CoderResult coderResult2;
            block14: {
                CoderResult coderResult3;
                block13: {
                    CoderResult coderResult4;
                    block12: {
                        CoderResult coderResult5;
                        block11: {
                            ByteOrder byteOrder = byteBuffer.order();
                            byteBuffer.order(this.byteOrder);
                            if (this.needsByteOrderMark) {
                                if (byteBuffer.remaining() < 2) {
                                    byteBuffer.order(byteOrder);
                                    return CoderResult.OVERFLOW;
                                }
                                byteBuffer.putChar('\ufeff');
                                this.needsByteOrderMark = false;
                            }
                            n = charBuffer.position();
                            try {
                                while (charBuffer.hasRemaining()) {
                                    char c = charBuffer.get();
                                    if ('\ud800' <= c && c <= '\udfff') {
                                        if (c > '\udbff') {
                                            coderResult5 = CoderResult.malformedForLength(1);
                                            Object var9_11 = null;
                                            break block11;
                                        }
                                        if (charBuffer.remaining() < 1) {
                                            coderResult4 = CoderResult.UNDERFLOW;
                                            break block12;
                                        }
                                        char c2 = charBuffer.get();
                                        if (c2 < '\udc00' || c2 > '\udfff') {
                                            coderResult3 = CoderResult.malformedForLength(1);
                                            break block13;
                                        } else {
                                            byteBuffer.putChar(c);
                                            byteBuffer.putChar(c2);
                                            n += 2;
                                            continue;
                                        }
                                    }
                                    if (byteBuffer.remaining() < 2) {
                                        byteBuffer.order(byteOrder);
                                        coderResult2 = CoderResult.OVERFLOW;
                                        break block14;
                                    }
                                    byteBuffer.putChar(c);
                                    ++n;
                                }
                                byteBuffer.order(byteOrder);
                                coderResult = CoderResult.UNDERFLOW;
                                break block15;
                            }
                            catch (Throwable throwable) {
                                Object var9_16 = null;
                                charBuffer.position(n);
                                throw throwable;
                            }
                        }
                        charBuffer.position(n);
                        return coderResult5;
                    }
                    Object var9_12 = null;
                    charBuffer.position(n);
                    return coderResult4;
                }
                Object var9_13 = null;
                charBuffer.position(n);
                return coderResult3;
            }
            Object var9_14 = null;
            charBuffer.position(n);
            return coderResult2;
        }
        Object var9_15 = null;
        charBuffer.position(n);
        return coderResult;
    }

    protected void implReset() {
        this.needsByteOrderMark = this.useByteOrderMark;
    }
}

