/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import gnu.java.nio.charset.ByteDecodeLoopHelper;
import gnu.java.nio.charset.ByteEncodeLoopHelper;
import gnu.java.nio.charset.US_ASCII;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

final class ISO_8859_1
extends Charset {
    ISO_8859_1() {
        super("ISO-8859-1", new String[]{"iso-ir-100", "ISO_8859-1", "latin1", "l1", "IBM819", "CP819", "csISOLatin1", "8859_1", "ISO8859_1", "ISO_8859_1", "ibm-819", "ISO_8859-1:1987", "819", "ISO8859-1"});
    }

    public boolean contains(Charset charset) {
        return charset instanceof US_ASCII || charset instanceof ISO_8859_1;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static final class Encoder
    extends CharsetEncoder {
        private static final ByteEncodeLoopHelper helper = new ByteEncodeLoopHelper(){

            protected boolean isMappable(char c) {
                return c <= '\u00ff';
            }

            protected byte mapToByte(char c) {
                return (byte)c;
            }
        };

        Encoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        public boolean canEncode(char c) {
            return c <= '\u00ff';
        }

        public boolean canEncode(CharSequence charSequence) {
            for (int i = 0; i < charSequence.length(); ++i) {
                if (this.canEncode(charSequence.charAt(i))) continue;
                return false;
            }
            return true;
        }

        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            return helper.encodeLoop(charBuffer, byteBuffer);
        }
    }

    private static final class Decoder
    extends CharsetDecoder {
        private static final ByteDecodeLoopHelper helper = new ByteDecodeLoopHelper(){

            protected boolean isMappable(byte by) {
                return true;
            }

            protected char mapToChar(byte by) {
                return (char)(by & 0xFF);
            }
        };

        Decoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            return helper.decodeLoop(byteBuffer, charBuffer);
        }
    }
}

