/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import gnu.java.nio.charset.ByteDecodeLoopHelper;
import gnu.java.nio.charset.ByteEncodeLoopHelper;
import gnu.java.nio.charset.US_ASCII;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

abstract class ByteCharset
extends Charset {
    protected final char[] lookupTable;
    protected static final char NONE = '\ufffd';

    ByteCharset(String string, String[] stringArray, char[] cArray) {
        super(string, stringArray);
        this.lookupTable = cArray;
    }

    public boolean contains(Charset charset) {
        return charset instanceof US_ASCII || charset.getClass() == this.getClass();
    }

    char[] getLookupTable() {
        return this.lookupTable;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static final class Encoder
    extends CharsetEncoder {
        private final byte[] lookup;
        private final ByteEncodeLoopHelper helper = new ByteEncodeLoopHelper(){

            protected boolean isMappable(char c) {
                return Encoder.this.canEncode(c);
            }

            protected byte mapToByte(char c) {
                return Encoder.this.lookup[c];
            }
        };

        Encoder(ByteCharset byteCharset) {
            super(byteCharset, 1.0f, 1.0f);
            char c;
            int n;
            char[] cArray = byteCharset.getLookupTable();
            char c2 = '\u0000';
            for (n = 0; n < cArray.length; ++n) {
                c = cArray[n];
                c2 = c > c2 && c < '\ufffd' ? c : c2;
            }
            this.lookup = new byte[c2 + 1];
            for (n = 0; n < cArray.length; ++n) {
                c = cArray[n];
                if (c == '\u0000' || c >= '\ufffd') continue;
                this.lookup[c] = (byte)n;
            }
        }

        public boolean canEncode(char c) {
            byte by = c < this.lookup.length ? this.lookup[c] : (byte)0;
            return by != 0 || c == '\u0000';
        }

        public boolean canEncode(CharSequence charSequence) {
            for (int i = 0; i < charSequence.length(); ++i) {
                if (this.canEncode(charSequence.charAt(i))) continue;
                return false;
            }
            return true;
        }

        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            return this.helper.encodeLoop(charBuffer, byteBuffer);
        }
    }

    private static final class Decoder
    extends CharsetDecoder {
        private final char[] lookup;
        private final ByteDecodeLoopHelper helper = new ByteDecodeLoopHelper(){

            protected boolean isMappable(byte by) {
                return Decoder.this.lookup[by & 0xFF] != '\ufffd';
            }

            protected char mapToChar(byte by) {
                return Decoder.this.lookup[by & 0xFF];
            }
        };

        Decoder(ByteCharset byteCharset) {
            super(byteCharset, 1.0f, 1.0f);
            this.lookup = byteCharset.getLookupTable();
        }

        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            return this.helper.decodeLoop(byteBuffer, charBuffer);
        }
    }
}

