/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.nio.NIOSocket;
import gnu.java.nio.SelectorProviderImpl;
import gnu.java.nio.VMChannel;
import gnu.java.nio.VMChannelOwner;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NoConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.nio.channels.UnsupportedAddressTypeException;
import java.nio.channels.spi.SelectorProvider;

public final class SocketChannelImpl
extends SocketChannel
implements VMChannelOwner {
    private VMChannel channel;
    private NIOSocket socket;
    private boolean connectionPending;
    private boolean connected;
    private InetSocketAddress connectAddress;

    public SocketChannelImpl(boolean bl) throws IOException {
        this(new SelectorProviderImpl(), bl);
    }

    public SocketChannelImpl(VMChannel vMChannel) throws IOException {
        this(new SelectorProviderImpl(), vMChannel, false);
    }

    SocketChannelImpl(SelectorProvider selectorProvider) throws IOException {
        this(selectorProvider, true);
    }

    SocketChannelImpl(SelectorProvider selectorProvider, boolean bl) throws IOException {
        this(selectorProvider, new VMChannel(), bl);
    }

    SocketChannelImpl(SelectorProvider selectorProvider, VMChannel vMChannel, boolean bl) throws IOException {
        super(selectorProvider);
        this.channel = vMChannel;
        if (bl) {
            vMChannel.initSocket(true);
        }
        this.socket = new NIOSocket(this);
        this.configureBlocking(true);
    }

    public void finalizer() {
        if (this.isConnected()) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void implCloseSelectableChannel() throws IOException {
        this.channel.close();
    }

    protected void implConfigureBlocking(boolean bl) throws IOException {
        this.channel.setBlocking(bl);
    }

    public boolean connect(SocketAddress socketAddress) throws IOException {
        return this.connect(socketAddress, 0);
    }

    public boolean connect(SocketAddress socketAddress, int n) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (this.isConnected()) {
            throw new AlreadyConnectedException();
        }
        if (this.connectionPending) {
            throw new ConnectionPendingException();
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new UnsupportedAddressTypeException();
        }
        this.connectAddress = (InetSocketAddress)socketAddress;
        if (this.connectAddress.isUnresolved()) {
            throw new UnresolvedAddressException();
        }
        this.connected = this.channel.connect(this.connectAddress, n);
        this.connectionPending = !this.connected;
        return this.connected;
    }

    public boolean finishConnect() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        InetSocketAddress inetSocketAddress = this.channel.getPeerAddress();
        if (inetSocketAddress != null) {
            this.connectionPending = false;
            return true;
        }
        if (!this.connectionPending) {
            throw new NoConnectionPendingException();
        }
        return false;
    }

    public boolean isConnected() {
        if (this.connectionPending) {
            return false;
        }
        try {
            InetSocketAddress inetSocketAddress = this.channel.getPeerAddress();
            return inetSocketAddress != null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.out);
            return false;
        }
    }

    public boolean isConnectionPending() {
        return this.connectionPending;
    }

    public Socket socket() {
        return this.socket;
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        return this.channel.read(byteBuffer);
    }

    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        if (n < 0 || n > byteBufferArray.length || n2 < 0 || n2 > byteBufferArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        return this.channel.readScattering(byteBufferArray, n, n2);
    }

    public int write(ByteBuffer byteBuffer) throws IOException {
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        return this.channel.write(byteBuffer);
    }

    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        if (n < 0 || n > byteBufferArray.length || n2 < 0 || n2 > byteBufferArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        return this.channel.writeGathering(byteBufferArray, n, n2);
    }

    public VMChannel getVMChannel() {
        return this.channel;
    }
}

