/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.nio.KqueueSelectionKeyImpl;
import gnu.java.nio.VMChannelOwner;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class KqueueSelectorImpl
extends AbstractSelector {
    private static final int _sizeof_struct_kevent;
    private static final int MAX_DOUBLING_CAPACITY = 16384;
    private static final int CAP_INCREMENT = 1024;
    private static final int INITIAL_CAPACITY;
    private int kq = KqueueSelectorImpl.implOpen();
    private HashMap keys = new HashMap();
    private HashSet selected;
    private Thread blockedThread;
    private ByteBuffer events = ByteBuffer.allocateDirect(INITIAL_CAPACITY);
    private static final int OP_ACCEPT = 16;
    private static final int OP_CONNECT = 8;
    private static final int OP_READ = 1;
    private static final int OP_WRITE = 4;

    public static native boolean kqueue_supported();

    public KqueueSelectorImpl(SelectorProvider selectorProvider) throws IOException {
        super(selectorProvider);
    }

    protected void implCloseSelector() throws IOException {
        KqueueSelectorImpl.implClose(this.kq);
        this.kq = -1;
    }

    public Set keys() {
        if (!this.isOpen()) {
            throw new ClosedSelectorException();
        }
        return new HashSet(this.keys.values());
    }

    public int select() throws IOException {
        return this.doSelect(-1L);
    }

    public int select(long l) throws IOException {
        if (l == 0L) {
            l = -1L;
        }
        return this.doSelect(l);
    }

    public Set selectedKeys() {
        if (!this.isOpen()) {
            throw new ClosedSelectorException();
        }
        return this.selected;
    }

    public int selectNow() throws IOException {
        return this.doSelect(0L);
    }

    public Selector wakeup() {
        if (this.blockedThread != null) {
            this.blockedThread.interrupt();
        }
        return this;
    }

    public String toString() {
        return super.toString() + " [ fd: " + this.kq + " ]";
    }

    public boolean equals(Object object) {
        if (!(object instanceof KqueueSelectorImpl)) {
            return false;
        }
        return ((KqueueSelectorImpl)object).kq == this.kq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    int doSelect(long l) throws IOException {
        Set<SelectionKey> set;
        Set<SelectionKey> set2 = set = this.cancelledKeys();
        synchronized (set2) {
            HashMap hashMap = this.keys;
            synchronized (hashMap) {
                void var7_9;
                for (KqueueSelectionKeyImpl kqueueSelectionKeyImpl : set) {
                    kqueueSelectionKeyImpl.interestOps = 0;
                }
                int n = 2 * _sizeof_struct_kevent * this.keys.size();
                boolean n2 = false;
                Iterator n3 = this.keys.entrySet().iterator();
                while (n3.hasNext()) {
                    Map.Entry n4 = n3.next();
                    KqueueSelectionKeyImpl i = (KqueueSelectionKeyImpl)n4.getValue();
                    SelectableChannel n5 = i.channel();
                    if (n5 instanceof VMChannelOwner && !((VMChannelOwner)((Object)n5)).getVMChannel().getState().isValid()) {
                        n3.remove();
                        continue;
                    }
                    if (i.needCommitRead()) {
                        KqueueSelectorImpl.kevent_set(this.events, (int)var7_9, i.fd, i.interestOps & 0x11, i.activeOps & 0x11, i.key);
                        ++var7_9;
                    }
                    if (!i.needCommitWrite()) continue;
                    KqueueSelectorImpl.kevent_set(this.events, (int)var7_9, i.fd, i.interestOps & 0xC, i.activeOps & 0xC, i.key);
                    ++var7_9;
                }
                this.events.rewind().limit(this.events.capacity());
                int n4 = 0;
                try {
                    this.begin();
                    this.blockedThread = Thread.currentThread();
                    if (this.blockedThread.isInterrupted()) {
                        l = 0L;
                    }
                    n4 = KqueueSelectorImpl.kevent(this.kq, this.events, (int)var7_9, this.events.capacity() / _sizeof_struct_kevent, l);
                    Object var13_20 = null;
                }
                catch (Throwable kqueueSelectionKeyImpl) {
                    Object var13_21 = null;
                    this.end();
                    this.blockedThread = null;
                    Thread.interrupted();
                    throw kqueueSelectionKeyImpl;
                }
                this.end();
                this.blockedThread = null;
                Thread.interrupted();
                for (KqueueSelectionKeyImpl i : this.keys.values()) {
                    i.activeOps = i.interestOps;
                }
                this.selected = new HashSet(n4);
                int n5 = 0;
                for (int iterator2 = 0; iterator2 < n4; ++iterator2) {
                    this.events.position(n5).limit(n5 + _sizeof_struct_kevent);
                    n5 += _sizeof_struct_kevent;
                    int kqueueSelectionKeyImpl = KqueueSelectorImpl.fetch_key(this.events.slice());
                    KqueueSelectionKeyImpl kqueueSelectionKeyImpl2 = (KqueueSelectionKeyImpl)this.keys.get(new Integer(kqueueSelectionKeyImpl));
                    if (kqueueSelectionKeyImpl2 == null) {
                        System.out.println("WARNING! no key found for selected key " + kqueueSelectionKeyImpl);
                        continue;
                    }
                    if (!kqueueSelectionKeyImpl2.isValid()) continue;
                    kqueueSelectionKeyImpl2.readyOps = KqueueSelectorImpl.ready_ops(this.events.slice(), kqueueSelectionKeyImpl2.interestOps);
                    this.selected.add(kqueueSelectionKeyImpl2);
                }
                Iterator<SelectionKey> iterator = set.iterator();
                while (iterator.hasNext()) {
                    KqueueSelectionKeyImpl kqueueSelectionKeyImpl = (KqueueSelectionKeyImpl)iterator.next();
                    this.keys.remove(new Integer(kqueueSelectionKeyImpl.key));
                    this.deregister(kqueueSelectionKeyImpl);
                    iterator.remove();
                }
                this.reallocateBuffer();
                return this.selected.size();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SelectionKey register(AbstractSelectableChannel abstractSelectableChannel, int n, Object object) {
        int n2 = -1;
        try {
            if (!(abstractSelectableChannel instanceof VMChannelOwner)) {
                throw new IllegalArgumentException("cannot handle channel type " + abstractSelectableChannel.getClass().getName());
            }
            n2 = ((VMChannelOwner)((Object)abstractSelectableChannel)).getVMChannel().getState().getNativeFD();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("channel is closed or invalid");
        }
        KqueueSelectionKeyImpl kqueueSelectionKeyImpl = new KqueueSelectionKeyImpl(this, abstractSelectableChannel);
        kqueueSelectionKeyImpl.interestOps = n;
        kqueueSelectionKeyImpl.attach(object);
        kqueueSelectionKeyImpl.fd = n2;
        kqueueSelectionKeyImpl.key = System.identityHashCode(kqueueSelectionKeyImpl);
        HashMap hashMap = this.keys;
        synchronized (hashMap) {
            while (this.keys.containsKey(new Integer(kqueueSelectionKeyImpl.key))) {
                ++kqueueSelectionKeyImpl.key;
            }
            this.keys.put(new Integer(kqueueSelectionKeyImpl.key), kqueueSelectionKeyImpl);
            this.reallocateBuffer();
        }
        return kqueueSelectionKeyImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInterestOps(KqueueSelectionKeyImpl kqueueSelectionKeyImpl, int n) {
        HashMap hashMap = this.keys;
        synchronized (hashMap) {
            kqueueSelectionKeyImpl.interestOps = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reallocateBuffer() {
        HashMap hashMap = this.keys;
        synchronized (hashMap) {
            if (this.events.capacity() < 2 * _sizeof_struct_kevent * this.keys.size()) {
                int n = this.events.capacity();
                n = n >= 16384 ? (n += 1024) : (n <<= 1);
                this.events = ByteBuffer.allocateDirect(n);
            } else if (this.events.capacity() > 4 * _sizeof_struct_kevent * this.keys.size() + 1 && this.events.capacity() > INITIAL_CAPACITY) {
                int n = this.events.capacity();
                this.events = ByteBuffer.allocateDirect(n >>>= 1);
            }
        }
    }

    private void dump_selection_keys(ByteBuffer byteBuffer) {
        boolean bl = false;
        byteBuffer.order(ByteOrder.nativeOrder());
        while (byteBuffer.hasRemaining()) {
            System.out.println("struct kevent { ident: " + Integer.toString(byteBuffer.getInt()) + " filter: " + Integer.toHexString(byteBuffer.getShort() & 0xFFFF) + " flags: " + Integer.toHexString(byteBuffer.getShort() & 0xFFFF) + " fflags: " + Integer.toHexString(byteBuffer.getInt()) + " data: " + Integer.toHexString(byteBuffer.getInt()) + " udata: " + Integer.toHexString(byteBuffer.getInt()) + " }");
        }
    }

    private static native int sizeof_struct_kevent();

    private static native int implOpen() throws IOException;

    private static native void implClose(int var0) throws IOException;

    private static native void kevent_set(ByteBuffer var0, int var1, int var2, int var3, int var4, int var5);

    private static native int kevent(int var0, ByteBuffer var1, int var2, int var3, long var4);

    private static native int fetch_key(ByteBuffer var0);

    private static native int ready_ops(ByteBuffer var0, int var1);

    private static native boolean check_eof(ByteBuffer var0);

    static {
        try {
            System.loadLibrary("javanio");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        _sizeof_struct_kevent = KqueueSelectorImpl.kqueue_supported() ? KqueueSelectorImpl.sizeof_struct_kevent() : -1;
        INITIAL_CAPACITY = 16 * _sizeof_struct_kevent;
    }
}

