/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.nio.KqueueSelectorImpl;
import gnu.java.nio.VMChannelOwner;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectionKey;

public class KqueueSelectionKeyImpl
extends AbstractSelectionKey {
    int interestOps;
    int readyOps;
    int activeOps = 0;
    int key;
    int fd;
    private final KqueueSelectorImpl selector;
    private final SelectableChannel channel;
    private final VMChannelOwner natChannel;

    public KqueueSelectionKeyImpl(KqueueSelectorImpl kqueueSelectorImpl, SelectableChannel selectableChannel) {
        this.selector = kqueueSelectorImpl;
        this.channel = selectableChannel;
        this.natChannel = (VMChannelOwner)((Object)selectableChannel);
        this.interestOps = 0;
        this.readyOps = 0;
    }

    public SelectableChannel channel() {
        return this.channel;
    }

    public int interestOps() {
        return this.interestOps;
    }

    public SelectionKey interestOps(int n) {
        if (!this.isValid()) {
            throw new IllegalStateException("key is invalid");
        }
        if ((n & ~this.channel.validOps()) != 0) {
            throw new IllegalArgumentException("channel does not support all operations");
        }
        this.selector.setInterestOps(this, n);
        return this;
    }

    public int readyOps() {
        return this.readyOps;
    }

    public Selector selector() {
        return this.selector;
    }

    public String toString() {
        if (!this.isValid()) {
            return super.toString() + " [ fd: " + this.fd + " <<invalid>> ]";
        }
        return super.toString() + " [ fd: " + this.fd + " interest ops: {" + ((this.interestOps & 0x10) != 0 ? " OP_ACCEPT" : "") + ((this.interestOps & 8) != 0 ? " OP_CONNECT" : "") + ((this.interestOps & 1) != 0 ? " OP_READ" : "") + ((this.interestOps & 4) != 0 ? " OP_WRITE" : "") + " }; ready ops: {" + ((this.readyOps & 0x10) != 0 ? " OP_ACCEPT" : "") + ((this.readyOps & 8) != 0 ? " OP_CONNECT" : "") + ((this.readyOps & 1) != 0 ? " OP_READ" : "") + ((this.readyOps & 4) != 0 ? " OP_WRITE" : "") + " } ]";
    }

    public int hashCode() {
        return this.fd;
    }

    public boolean equals(Object object) {
        if (!(object instanceof KqueueSelectionKeyImpl)) {
            return false;
        }
        KqueueSelectionKeyImpl kqueueSelectionKeyImpl = (KqueueSelectionKeyImpl)object;
        return kqueueSelectionKeyImpl.fd == this.fd && kqueueSelectionKeyImpl.channel.equals(this.channel);
    }

    boolean isReadActive() {
        return (this.activeOps & 0x11) != 0;
    }

    boolean isReadInterested() {
        return (this.interestOps & 0x11) != 0;
    }

    boolean isWriteActive() {
        return (this.activeOps & 0xC) != 0;
    }

    boolean isWriteInterested() {
        return (this.interestOps & 0xC) != 0;
    }

    boolean needCommitRead() {
        return this.isReadActive() == !this.isReadInterested();
    }

    boolean needCommitWrite() {
        return this.isWriteActive() == !this.isWriteInterested();
    }
}

