/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;

public final class InputStreamChannel
implements ReadableByteChannel {
    private boolean closed = false;
    private InputStream in;

    public InputStreamChannel(InputStream inputStream) {
        this.in = inputStream;
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.in.close();
            this.closed = true;
        }
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        byte[] byArray = new byte[byteBuffer.remaining()];
        int n = this.in.read(byArray);
        if (n > 0) {
            byteBuffer.put(byArray, 0, n);
        }
        return n;
    }
}

